/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.shop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.gui.ShopGUI;
import net.godlycow.org.shopengine.shop.ShopItem;
import net.godlycow.org.shopengine.shop.ShopSection;
import org.bukkit.entity.Player;

public class ShopManager {
    private final ShopEngine plugin;
    private final Map<String, ShopSection> sections = new HashMap<String, ShopSection>();

    public ShopManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.loadShop();
    }

    public void loadShop() {
        this.sections.clear();
        Map<String, ShopSection> sectionMap = this.plugin.getSectionManager().getSections();
        for (Map.Entry<String, ShopSection> entry : sectionMap.entrySet()) {
            String sectionKey = entry.getKey();
            ShopSection section = entry.getValue();
            List<ShopItem> items = this.plugin.getItemManager().getItemsForSection(sectionKey);
            section.getItems().clear();
            section.getItems().addAll(items);
            this.sections.put(sectionKey, section);
        }
        this.plugin.getLogger().info("Loaded " + this.sections.size() + " shop sections with items!");
    }

    public void openShop(Player player) {
        new ShopGUI(this.plugin, player, null, 0).open();
    }

    public void openSection(Player player, String sectionKey) {
        ShopSection section = this.sections.get(sectionKey);
        if (section != null) {
            new ShopGUI(this.plugin, player, section, 0).open();
        }
    }

    public Map<String, ShopSection> getSections() {
        return new HashMap<String, ShopSection>(this.sections);
    }

    public List<ShopItem> getAllItems() {
        ArrayList<ShopItem> allItems = new ArrayList<ShopItem>();
        for (ShopSection section : this.sections.values()) {
            allItems.addAll(section.getItems());
        }
        return allItems;
    }

    public ShopSection getSection(String key) {
        return this.sections.get(key);
    }

    public boolean hasSection(String key) {
        return this.sections.containsKey(key);
    }
}

