/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.shop;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.shop.ShopItem;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DynamicPricingManager {
    private final ShopEngine plugin;
    private final File pricesFile;
    private final Map<String, Double> dynamicMultipliers = new HashMap<String, Double>();
    private long lastUpdate;

    public DynamicPricingManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.pricesFile = new File(plugin.getDataFolder(), "dynamic-prices.yml");
        this.loadPrices();
        this.startSaveTask();
    }

    public double getDynamicPrice(ShopItem item, boolean isBuy) {
        if (!this.plugin.getConfigManager().isDynamicPricingEnabled()) {
            return isBuy ? item.getBuyPrice() : item.getSellPrice();
        }
        String key = item.getKey();
        double basePrice = isBuy ? item.getBuyPrice() : item.getSellPrice();
        double multiplier = this.dynamicMultipliers.getOrDefault(key, 1.0);
        return basePrice * multiplier;
    }

    public void recordTransaction(ShopItem item, boolean isBuy, int amount) {
        if (!this.plugin.getConfigManager().isDynamicPricingEnabled()) {
            return;
        }
        String key = item.getKey();
        double currentMultiplier = this.dynamicMultipliers.getOrDefault(key, 1.0);
        double fluctuation = this.plugin.getConfigManager().getDynamicFluctuationPercent() / 100.0;
        double change = isBuy ? fluctuation * (double)amount * 0.01 : -fluctuation * (double)amount * 0.01;
        double newMultiplier = Math.max(0.1, Math.min(3.0, currentMultiplier + change));
        this.dynamicMultipliers.put(key, newMultiplier);
        this.plugin.getLogger().fine(String.format("Price for %s changed from %.2fx to %.2fx (%s %d)", key, currentMultiplier, newMultiplier, isBuy ? "bought" : "sold", amount));
    }

    public void dailyUpdate() {
        if (!this.plugin.getConfigManager().isDynamicPricingEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdate < 86400000L) {
            return;
        }
        double fluctuation = this.plugin.getConfigManager().getDynamicFluctuationPercent() / 100.0;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (String key : this.dynamicMultipliers.keySet()) {
            double current = this.dynamicMultipliers.get(key);
            double change = (random.nextDouble() - 0.5) * fluctuation * 2.0;
            double newMultiplier = Math.max(0.1, Math.min(3.0, current + change));
            this.dynamicMultipliers.put(key, newMultiplier);
        }
        this.lastUpdate = currentTime;
        this.plugin.getLogger().info("Daily dynamic price update completed!");
    }

    public void loadPrices() {
        if (!this.pricesFile.exists()) {
            this.plugin.getLogger().info("No dynamic prices file found, creating new one...");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.pricesFile);
        for (String key : config.getKeys(false)) {
            this.dynamicMultipliers.put(key, config.getDouble(key, 1.0));
        }
        this.lastUpdate = config.getLong("last-update", System.currentTimeMillis());
    }

    public void savePrices() {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<String, Double> entry : this.dynamicMultipliers.entrySet()) {
            config.set(entry.getKey(), (Object)entry.getValue());
        }
        config.set("last-update", (Object)this.lastUpdate);
        try {
            config.save(this.pricesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save dynamic prices: " + e.getMessage());
        }
    }

    private void startSaveTask() {
        long interval = this.plugin.getConfigManager().getSaveIntervalMinutes() * 1200L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::savePrices, interval, interval);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::dailyUpdate, 72000L, 72000L);
    }

    public Map<String, Double> getMultipliers() {
        return new HashMap<String, Double>(this.dynamicMultipliers);
    }

    public void resetPrice(String itemKey) {
        this.dynamicMultipliers.put(itemKey, 1.0);
    }
}

