/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.player.Transaction;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final ShopEngine plugin;
    private final File dataFolder;
    private final Map<UUID, PlayerData> cache = new ConcurrentHashMap<UUID, PlayerData>();

    public PlayerDataManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        plugin.getLogger().info("PlayerDataManager initialized!");
    }

    public PlayerData getPlayerData(Player player) {
        return this.cache.computeIfAbsent(player.getUniqueId(), uuid -> this.loadData(player));
    }

    private PlayerData loadData(Player player) {
        File file = new File(this.dataFolder, String.valueOf(player.getUniqueId()) + ".yml");
        PlayerData data = new PlayerData(player.getUniqueId());
        if (!file.exists()) {
            return data;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (config.contains("transactions")) {
                List transactions = config.getMapList("transactions");
                for (Map map : transactions) {
                    try {
                        Material material = Material.valueOf((String)((String)map.get("material")));
                        int amount = (Integer)map.get("amount");
                        double price = (Double)map.get("price");
                        boolean isBuy = (Boolean)map.get("isBuy");
                        long timestamp = ((Number)map.get("timestamp")).longValue();
                        Transaction transaction = new Transaction(material, amount, price, isBuy);
                        data.addTransaction(transaction);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to load transaction for " + player.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load player data for " + player.getName());
        }
        return data;
    }

    public void saveData(Player player) {
        PlayerData data = this.cache.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            File file = new File(this.dataFolder, String.valueOf(player.getUniqueId()) + ".yml");
            YamlConfiguration config = new YamlConfiguration();
            ArrayList transactions = new ArrayList();
            for (Transaction transaction : data.getTransactions()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("material", transaction.getMaterial().name());
                map.put("amount", transaction.getAmount());
                map.put("price", transaction.getPrice());
                map.put("isBuy", transaction.isBuy());
                map.put("timestamp", transaction.getTimestamp());
                transactions.add(map);
            }
            config.set("transactions", transactions);
            try {
                config.save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to save data for " + player.getName());
            }
        });
    }

    public void saveAll() {
        this.cache.keySet().forEach(uuid -> {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player != null && player.isOnline()) {
                this.saveData(player);
            }
        });
    }

    public void recordTransaction(Player player, Transaction transaction) {
        PlayerData data = this.getPlayerData(player);
        data.addTransaction(transaction);
        this.saveData(player);
    }

    public static class PlayerData {
        private final UUID uuid;
        private final List<Transaction> transactions = new ArrayList<Transaction>();

        public PlayerData(UUID uuid) {
            this.uuid = uuid;
        }

        public List<Transaction> getTransactions() {
            return new ArrayList<Transaction>(this.transactions);
        }

        public void addTransaction(Transaction transaction) {
            this.transactions.add(transaction);
            if (this.transactions.size() > 100) {
                this.transactions.remove(0);
            }
        }

        public List<Transaction> getRecentTransactions(int limit) {
            ArrayList<Transaction> recent = new ArrayList<Transaction>(this.transactions);
            Collections.reverse(recent);
            return recent.subList(0, Math.min(limit, recent.size()));
        }
    }
}

