/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.libs.signgui.version;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.godlycow.org.shopengine.libs.signgui.SignEditor;
import net.godlycow.org.shopengine.libs.signgui.SignGUIChannelHandler;
import net.godlycow.org.shopengine.libs.signgui.version.VersionWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class Wrapper1_18_R2
implements VersionWrapper {
    @Override
    public Material getDefaultType() {
        return Material.OAK_SIGN;
    }

    @Override
    public List<Material> getSignTypes() {
        return Arrays.asList(Material.OAK_SIGN, Material.BIRCH_SIGN, Material.SPRUCE_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN);
    }

    @Override
    public void openSignEditor(final Player player, String[] lines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, final BiConsumer<SignEditor, String[]> onFinish) {
        EntityPlayer p = ((CraftPlayer)player).getHandle();
        PlayerConnection conn = p.b;
        Location loc = signLoc != null ? signLoc : this.getDefaultLocation(player);
        final BlockPosition pos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        TileEntitySign sign = new TileEntitySign(pos, null);
        sign.a(EnumColor.valueOf((String)color.toString()));
        sign.b(glow);
        for (int i = 0; i < lines.length; ++i) {
            sign.a(i, IChatBaseComponent.a((String)lines[i]));
        }
        boolean schedule = false;
        ChannelPipeline pipeline = conn.a.m.pipeline();
        if (pipeline.names().contains("SignGUI")) {
            ChannelHandler handler = pipeline.get("SignGUI");
            if (handler instanceof SignGUIChannelHandler) {
                SignGUIChannelHandler signGUIHandler = (SignGUIChannelHandler)handler;
                signGUIHandler.close();
                schedule = signGUIHandler.getBlockPosition().equals(pos);
            }
            if (pipeline.names().contains("SignGUI")) {
                pipeline.remove("SignGUI");
            }
        }
        Runnable runnable = () -> {
            player.sendBlockChange(loc, type.createBlockData());
            conn.a((Packet)sign.c());
            conn.a((Packet)new PacketPlayOutOpenSignEditor(pos));
            final SignEditor signEditor = new SignEditor(sign, loc, pos, pipeline);
            pipeline.addAfter("decoder", "SignGUI", (ChannelHandler)new SignGUIChannelHandler<Packet<?>>(){

                @Override
                public Object getBlockPosition() {
                    return pos;
                }

                @Override
                public void close() {
                    Wrapper1_18_R2.this.closeSignEditor(player, signEditor);
                }

                protected void decode(ChannelHandlerContext chc, Packet<?> packet, List<Object> out) {
                    try {
                        PacketPlayInUpdateSign updateSign;
                        if (packet instanceof PacketPlayInUpdateSign && (updateSign = (PacketPlayInUpdateSign)packet).b().equals((Object)pos)) {
                            onFinish.accept(signEditor, updateSign.c());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    out.add(packet);
                }
            });
        };
        if (schedule) {
            SCHEDULER.schedule(runnable, 200L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public void displayNewLines(Player player, SignEditor signEditor, String[] lines, Object[] adventureLines) {
        TileEntitySign sign = (TileEntitySign)signEditor.getSign();
        for (int i = 0; i < lines.length; ++i) {
            sign.a(i, IChatBaseComponent.a((String)lines[i]));
        }
        PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
        conn.a((Packet)sign.c());
        conn.a((Packet)new PacketPlayOutOpenSignEditor((BlockPosition)signEditor.getBlockPosition()));
    }

    @Override
    public void closeSignEditor(Player player, SignEditor signEditor) {
        Location loc = signEditor.getLocation();
        signEditor.getPipeline().remove("SignGUI");
        player.sendBlockChange(loc, loc.getBlock().getBlockData());
    }
}

