/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.libs.signgui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import net.godlycow.org.shopengine.libs.signgui.SignEditor;
import net.godlycow.org.shopengine.libs.signgui.SignGUIAction;
import net.godlycow.org.shopengine.libs.signgui.SignGUIBuilder;
import net.godlycow.org.shopengine.libs.signgui.SignGUIException;
import net.godlycow.org.shopengine.libs.signgui.SignGUIFinishHandler;
import net.godlycow.org.shopengine.libs.signgui.SignGUIResult;
import net.godlycow.org.shopengine.libs.signgui.version.VersionWrapper;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SignGUI {
    static final VersionWrapper WRAPPER;
    static final String availableSignTypes;
    private final String[] lines;
    private final Object[] adventureLines;
    private final Material type;
    private final DyeColor color;
    private final boolean glow;
    private final Location signLoc;
    private final SignGUIFinishHandler handler;
    private final boolean callHandlerSynchronously;
    private final JavaPlugin plugin;

    private static boolean useMojangMappings(String version) {
        int minor;
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        String[] versionNumbers = version.replace("R", "").split("_");
        int major = Integer.parseInt(versionNumbers[1]);
        int n = minor = versionNumbers.length > 2 ? Integer.parseInt(versionNumbers[2]) : 0;
        if (major == 20 && minor == 4) {
            return true;
        }
        return major > 20;
    }

    public static SignGUIBuilder builder() {
        return new SignGUIBuilder();
    }

    SignGUI(String[] lines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, SignGUIFinishHandler handler, boolean callHandlerSynchronously, JavaPlugin plugin) {
        this.lines = lines;
        this.adventureLines = adventureLines;
        this.type = type;
        this.color = color;
        this.glow = glow;
        this.signLoc = signLoc;
        this.handler = handler;
        this.callHandlerSynchronously = callHandlerSynchronously;
        this.plugin = plugin;
    }

    public void open(Player player) throws SignGUIException {
        Validate.notNull((Object)player, (String)"The player cannot be null");
        try {
            WRAPPER.openSignEditor(player, this.lines, this.adventureLines, this.type, this.color, this.glow, this.signLoc, (signEditor, resultLines) -> {
                Runnable runnable = () -> {
                    Runnable close = () -> WRAPPER.closeSignEditor(player, (SignEditor)signEditor);
                    List<SignGUIAction> actions = this.handler.onFinish(player, new SignGUIResult((String[])resultLines));
                    if (actions == null || actions.isEmpty()) {
                        close.run();
                        return;
                    }
                    boolean keepOpen = false;
                    for (SignGUIAction action : actions) {
                        SignGUIAction.SignGUIActionInfo info = action.getInfo();
                        for (SignGUIAction otherAction : actions) {
                            SignGUIAction.SignGUIActionInfo otherInfo;
                            if (action == otherAction || !info.isConflicting(otherInfo = otherAction.getInfo())) continue;
                            close.run();
                            throw new SignGUIException("The actions " + info.getName() + " and " + otherInfo.getName() + " are conflicting");
                        }
                        if (!info.isKeepOpen()) continue;
                        keepOpen = true;
                    }
                    if (!keepOpen) {
                        close.run();
                    }
                    for (SignGUIAction action : actions) {
                        action.execute(this, (SignEditor)signEditor, player);
                    }
                };
                if (this.callHandlerSynchronously) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
                } else {
                    runnable.run();
                }
            });
        }
        catch (Exception e) {
            throw new SignGUIException("Failed to open sign gui", e);
        }
    }

    void displayNewLines(Player player, SignEditor signEditor, String[] lines, Object[] adventureLines) {
        Validate.notNull((Object)lines, (String)"The lines cannot be null");
        Validate.isTrue((lines.length == 4 ? 1 : 0) != 0, (String)"The lines must have a length of 4");
        if (adventureLines != null) {
            Validate.isTrue((adventureLines.length == 4 ? 1 : 0) != 0, (String)"The adventure lines must null or have a length of 4");
        }
        try {
            WRAPPER.displayNewLines(player, signEditor, lines, adventureLines);
        }
        catch (Exception e) {
            throw new SignGUIException("Failed to display new lines", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String craftBukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
        String version = null;
        if (!craftBukkitPackage.contains(".v")) {
            String bukkitVersion = Bukkit.getBukkitVersion();
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL("https://raw.githubusercontent.com/Rapha149/NMSVersions/main/nms-versions.json").openConnection();
                conn.setConnectTimeout(10000);
                conn.setRequestMethod("GET");
                conn.connect();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    JSONObject json = (JSONObject)new JSONParser().parse(br.lines().collect(Collectors.joining()));
                    if (json.containsKey((Object)bukkitVersion)) {
                        version = (String)json.get((Object)bukkitVersion);
                    }
                }
            }
            catch (IOException | ParseException e) {
                Bukkit.getLogger().warning("[SignGUI] Can't access online NMS versions list, falling back to hardcoded NMS versions. These could be outdated.");
            }
            if (version == null) {
                int minor;
                String[] versionNumbers = bukkitVersion.split("-")[0].split("\\.");
                int major = Integer.parseInt(versionNumbers[1]);
                int n = minor = versionNumbers.length > 2 ? Integer.parseInt(versionNumbers[2]) : 0;
                if (major == 20 && minor >= 5) {
                    version = "1_20_R4";
                } else {
                    if (major != 21 || minor != 0) throw new IllegalStateException("SignGUI does not support bukkit server version \"" + bukkitVersion + "\"");
                    version = "1_21_R1";
                }
            }
        } else {
            version = craftBukkitPackage.split("\\.")[3].substring(1);
        }
        String className = SignGUI.useMojangMappings(version) ? VersionWrapper.class.getPackage().getName() + ".MojangWrapper" + version : VersionWrapper.class.getPackage().getName() + ".Wrapper" + version;
        try {
            WRAPPER = (VersionWrapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException("Failed to load support for server version " + version, exception);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("SignGUI does not support the server version \"" + version + "\"", exception);
        }
        availableSignTypes = WRAPPER.getSignTypes().stream().map(Enum::toString).collect(Collectors.joining(", "));
    }
}

