/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.player.Transaction;
import net.godlycow.org.shopengine.shop.ShopItem;
import net.godlycow.org.shopengine.utils.ItemBuilder;
import net.godlycow.org.shopengine.utils.NumberUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SearchResultsGUI
implements InventoryHolder {
    private final ShopEngine plugin;
    private final Player player;
    private final String searchTerm;
    private final List<ShopItem> results;
    private final Inventory inventory;
    private int page = 0;
    private static final int ITEMS_PER_PAGE = 45;

    public SearchResultsGUI(ShopEngine plugin, Player player, String searchTerm) {
        this.plugin = plugin;
        this.player = player;
        this.searchTerm = searchTerm;
        this.results = plugin.getShopManager().getAllItems().stream().filter(item -> this.matchesSearch((ShopItem)item, searchTerm)).collect(Collectors.toList());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)plugin.getMiniMessage().deserialize((Object)plugin.getMessageManager().getMessage("gui.search.title").replace("<term>", searchTerm)));
        this.initialize();
    }

    private boolean matchesSearch(ShopItem item, String term) {
        String search = term.toLowerCase();
        return item.getKey().toLowerCase().contains(search) || item.getMaterial().name().toLowerCase().contains(search) || item.getDisplayName().toLowerCase().contains(search);
    }

    private void initialize() {
        this.inventory.clear();
        if (this.results.isEmpty()) {
            ItemBuilder empty = new ItemBuilder(this.plugin, Material.BARRIER).name(this.plugin.getMessageManager().getMessage("shop.search-no-results").replace("<term>", this.searchTerm));
            this.inventory.setItem(22, empty.build());
            this.setupCloseButton();
            return;
        }
        int totalPages = (int)Math.ceil((double)this.results.size() / 45.0);
        this.page = Math.min(this.page, Math.max(0, totalPages - 1));
        int startIndex = this.page * 45;
        for (int i = 0; i < 45 && startIndex + i < this.results.size(); ++i) {
            ShopItem item = this.results.get(startIndex + i);
            this.displayItem(i, item);
        }
        this.setupNavigation(totalPages);
    }

    private void displayItem(int slot, ShopItem item) {
        double buyPrice = this.plugin.getDynamicPricingManager().getDynamicPrice(item, true);
        double sellPrice = this.plugin.getDynamicPricingManager().getDynamicPrice(item, false);
        ItemBuilder builder = new ItemBuilder(this.plugin, item.getMaterial()).name((String)(item.getDisplayName().isEmpty() ? "<white>" + item.getMaterial().name() : item.getDisplayName())).amount(item.getAmount()).lore(this.plugin.getMessageManager().getMessage("gui.lore.buy-price").replace("<price>", NumberUtils.format(buyPrice)), this.plugin.getMessageManager().getMessage("gui.lore.sell-price").replace("<price>", NumberUtils.format(sellPrice)), "", this.plugin.getMessageManager().getMessage("gui.search.click-to-buy"), this.plugin.getMessageManager().getMessage("gui.search.click-to-sell"));
        if (item.getCustomModelData() > 0) {
            builder.customModelData(item.getCustomModelData());
        }
        this.inventory.setItem(slot, builder.build());
    }

    private void setupNavigation(int totalPages) {
        if (this.page > 0) {
            ItemBuilder prev = new ItemBuilder(this.plugin, Material.ARROW).name(this.plugin.getMessageManager().getMessage("gui.search.previous"));
            this.inventory.setItem(48, prev.build());
        }
        if (this.page < totalPages - 1) {
            ItemBuilder next = new ItemBuilder(this.plugin, Material.ARROW).name(this.plugin.getMessageManager().getMessage("gui.search.next"));
            this.inventory.setItem(50, next.build());
        }
        ItemBuilder searchAgain = new ItemBuilder(this.plugin, Material.OAK_SIGN).name(this.plugin.getMessageManager().getMessage("gui.search.search-again")).lore(this.plugin.getMessageManager().getMessage("gui.search.search-lore"));
        this.inventory.setItem(49, searchAgain.build());
    }

    private void setupCloseButton() {
        ItemBuilder close = new ItemBuilder(this.plugin, Material.BARRIER).name(this.plugin.getMessageManager().getMessage("gui.search.close"));
        this.inventory.setItem(49, close.build());
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        int slot = event.getSlot();
        int clickedItemIndex = this.page * 45 + slot;
        if (slot < 45 && clickedItemIndex < this.results.size()) {
            ShopItem item = this.results.get(clickedItemIndex);
            if (event.isLeftClick()) {
                this.executeTransaction(item, true, 1);
            } else {
                this.executeTransaction(item, false, 1);
            }
        } else if (slot == 48 && this.page > 0) {
            --this.page;
            this.initialize();
        } else if (slot == 50) {
            ++this.page;
            this.initialize();
        } else if (slot == 49) {
            if (this.results.isEmpty()) {
                this.player.closeInventory();
            } else {
                this.plugin.getSignInputManager().openSearch(this.player, term -> {
                    if (!term.isEmpty()) {
                        new SearchResultsGUI(this.plugin, this.player, (String)term).open();
                    }
                });
            }
        }
    }

    private void executeTransaction(ShopItem item, boolean isBuy, int amount) {
        if (isBuy && !item.canBuy()) {
            this.sendMessage("shop.cannot-buy");
            return;
        }
        if (!isBuy && !item.canSell()) {
            this.sendMessage("shop.cannot-sell");
            return;
        }
        double price = this.plugin.getDynamicPricingManager().getDynamicPrice(item, isBuy) * (double)amount;
        if (isBuy) {
            if (!this.plugin.getEconomyManager().hasEnough(this.player, price)) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("amount", NumberUtils.format(price));
                this.sendMessage("economy.not-enough-money", placeholders);
                return;
            }
            ItemStack itemStack = new ItemStack(item.getMaterial(), amount);
            if (!this.player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
                this.sendMessage("shop.inventory-full");
                return;
            }
            this.plugin.getEconomyManager().withdraw(this.player, price);
            this.plugin.getDynamicPricingManager().recordTransaction(item, true, amount);
            this.plugin.getPlayerDataManager().recordTransaction(this.player, new Transaction(item.getMaterial(), amount, price, true));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(amount));
            placeholders.put("item", item.getKey());
            placeholders.put("price", NumberUtils.format(price));
            this.sendMessage("shop.purchase-success", placeholders);
        } else {
            int itemCount = this.countItems(this.player, item.getMaterial());
            if (itemCount < amount) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("amount", String.valueOf(itemCount));
                this.sendMessage("shop.not-enough-items", placeholders);
                return;
            }
            this.removeItems(this.player, item.getMaterial(), amount);
            this.plugin.getEconomyManager().deposit(this.player, price);
            this.plugin.getDynamicPricingManager().recordTransaction(item, false, amount);
            this.plugin.getPlayerDataManager().recordTransaction(this.player, new Transaction(item.getMaterial(), amount, price, false));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(amount));
            placeholders.put("item", item.getKey());
            placeholders.put("price", NumberUtils.format(price));
            this.sendMessage("shop.sell-success", placeholders);
        }
        this.initialize();
    }

    private void sendMessage(String key) {
        String msg = this.plugin.getMessageManager().getMessage(key);
        this.player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }

    private void sendMessage(String key, Map<String, String> placeholders) {
        String msg = this.plugin.getMessageManager().getMessage(key, placeholders);
        this.player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }

    private int countItems(Player player, Material material) {
        return player.getInventory().all(material).values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    private void removeItems(Player player, Material material, int quantity) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            int amount = item.getAmount();
            if (amount > quantity) {
                item.setAmount(amount - quantity);
                break;
            }
            player.getInventory().remove(item);
            if ((quantity -= amount) == 0) break;
        }
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

