/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.economy;

import java.util.logging.Level;
import net.godlycow.org.shopengine.ShopEngine;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final ShopEngine plugin;
    private Economy economy;
    private String economyName;

    public EconomyManager(ShopEngine plugin) {
        this.plugin = plugin;
    }

    public boolean setup() {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.plugin.getLogger().severe("Vault plugin not found!");
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.plugin.getLogger().severe("No economy provider found!");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        this.economyName = this.economy.getName();
        this.plugin.getLogger().info("Economy hooked: " + this.economyName);
        return true;
    }

    public boolean hasEnough(Player player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public boolean withdraw(Player player, double amount) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        if (!response.transactionSuccess()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to withdraw $" + amount + " from " + player.getName() + ": " + response.errorMessage);
            return false;
        }
        return true;
    }

    public boolean deposit(Player player, double amount) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, amount);
        if (!response.transactionSuccess()) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to deposit $" + amount + " to " + player.getName() + ": " + response.errorMessage);
            return false;
        }
        return true;
    }

    public double getBalance(Player player) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public String format(double amount) {
        if (this.economy == null) {
            return String.format("$%.2f", amount);
        }
        return this.economy.format(amount);
    }

    public String getEconomyName() {
        return this.economyName;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void cleanup() {
    }
}

