/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.godlycow.org.shopengine.ShopEngine;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final ShopEngine plugin;
    private final File messagesFile;
    private FileConfiguration messagesConfig;
    private final Map<String, String> messageCache = new HashMap<String, String>();

    public MessageManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.messagesFile = new File(plugin.getDataFolder(), "shopmessages.yml");
        this.loadMessages();
    }

    private void loadMessages() {
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("shopmessages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.cacheMessages();
        this.plugin.getLogger().info("Loaded " + this.messageCache.size() + " messages!");
    }

    private void cacheMessages() {
        this.messageCache.clear();
        this.cacheSection((ConfigurationSection)this.messagesConfig, "");
        this.ensureDefaults();
        this.save();
    }

    private void cacheSection(ConfigurationSection section, String parentKey) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            String fullKey;
            String string = fullKey = parentKey.isEmpty() ? key : parentKey + "." + key;
            if (section.isConfigurationSection(key)) {
                this.cacheSection(section.getConfigurationSection(key), fullKey);
                continue;
            }
            if (!section.isString(key)) continue;
            this.messageCache.put(fullKey, section.getString(key));
        }
    }

    private void ensureDefaults() {
        this.ensureDefault("prefix", "<dark_gray>[<gradient:#00ff00:#00ffff>ShopEngine</gradient>]</dark_gray>");
        this.ensureDefault("no-permission", "<red>You don't have permission to use this!");
        this.ensureDefault("player-only", "<red>This command can only be used by players!");
        this.ensureDefault("economy.not-enough-money", "<red>You don't have enough money! <gray>(Need: <gold>$<amount></gold>)");
        this.ensureDefault("economy.balance", "<green>Your balance: <gold>$<balance>");
        this.ensureDefault("economy.transaction-failed", "<red>Transaction failed! Please contact an admin.");
        this.ensureDefault("shop.cannot-buy", "<red>You cannot buy this item!");
        this.ensureDefault("shop.cannot-sell", "<red>You cannot sell this item!");
        this.ensureDefault("shop.not-enough-stock", "<red>Not enough stock! <gray>(Available: <yellow><stock></yellow>)");
        this.ensureDefault("shop.inventory-full", "<red>Your inventory is full!");
        this.ensureDefault("shop.not-enough-items", "<red>You don't have enough items! <gray>(You have: <white><amount></white>)");
        this.ensureDefault("shop.purchase-success", "<green>\u2713 Purchased <white><amount>x <item> <green>for <gold>$<price>!");
        this.ensureDefault("shop.sell-success", "<green>\u2713 Sold <white><amount>x <item> <green>for <gold>$<price>!");
        this.ensureDefault("dynamic-prices.high", "<gold>\u25b2 Prices are high");
        this.ensureDefault("dynamic-prices.low", "<aqua>\u25bc Prices are low");
        this.ensureDefault("gui.titles.main-shop", "<gradient:#00ff00:#00ffff>Shop</gradient>");
        this.ensureDefault("gui.titles.section", "<section>");
        this.ensureDefault("gui.lore.click-to-view", "<gray>Click to view items!");
        this.ensureDefault("gui.lore.your-balance", "<gray>Your balance: <gold>$<balance>");
        this.ensureDefault("gui.lore.buy-price", "<green>Buy: <white>$<price>");
        this.ensureDefault("gui.lore.sell-price", "<red>Sell: <white>$<price>");
        this.ensureDefault("gui.lore.stock", "<gray>Stock: <yellow><stock>");
        this.ensureDefault("gui.lore.back-title", "<red>\u2190 Back");
        this.ensureDefault("gui.lore.back-button", "<gray>Return to main menu");
        this.ensureDefault("gui.lore.filler", "<gray>\u2022");
        this.ensureDefault("gui.lore.left-click-buy", "<yellow>Left-Click <gray>to buy 1");
        this.ensureDefault("gui.lore.right-click-sell", "<yellow>Right-Click <gray>to sell 1");
        this.ensureDefault("gui.lore.shift-left-buy", "<yellow>Shift-Left <gray>to buy 64");
        this.ensureDefault("gui.lore.shift-right-sell", "<yellow>Shift-Right <gray>to sell all");
        this.ensureDefault("commands.reload-success", "<green>ShopEngine configuration reloaded!");
        this.ensureDefault("commands.reload-config", "<green>Configuration reloaded!");
        this.ensureDefault("commands.reload-messages", "<green>Messages reloaded!");
        this.ensureDefault("commands.reload-sections", "<green>Sections reloaded!");
        this.ensureDefault("commands.reload-items", "<green>Items reloaded!");
        this.ensureDefault("commands.reload-unknown", "<red>Unknown reload target! Use: <white>all|config|messages|sections|items");
        this.ensureDefault("commands.resetprice-success", "<green>Price multiplier reset for <white><item>!");
        this.ensureDefault("commands.resetprice-usage", "<red>Usage: /shop resetprice <item-key>");
        this.ensureDefault("commands.help.header", "<gold>ShopEngine Commands:");
        this.ensureDefault("commands.help.shop", "<yellow>/shop <gray>- Open the shop");
        this.ensureDefault("commands.help.balance", "<yellow>/shop balance <gray>- Check your balance");
        this.ensureDefault("commands.help.reload", "<yellow>/shop reload <all|config|messages|sections|items> <gray>- Reload configuration");
        this.ensureDefault("commands.help.resetprice", "<yellow>/shop resetprice <item> <gray>- Reset dynamic price");
        this.ensureDefault("commands.help.help", "<yellow>/shop help <gray>- Show this help");
        this.ensureDefault("commands.unknown", "<red>Unknown subcommand! Use: <white>/shop help");
    }

    private void ensureDefault(String key, String defaultValue) {
        if (!this.messageCache.containsKey(key)) {
            this.messageCache.put(key, defaultValue);
            this.messagesConfig.set(key, (Object)defaultValue);
        }
    }

    public String getMessage(String key) {
        return this.messageCache.getOrDefault(key, "<red>Message not found: " + key);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return message;
    }

    public void reload() {
        this.loadMessages();
        this.plugin.getLogger().info("Messages reloaded!");
    }

    public void save() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save shopmessages.yml!", e);
        }
    }
}

