/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.shop.ShopItem;
import net.godlycow.org.shopengine.shop.ShopSection;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ShopEngine plugin;
    private FileConfiguration config;
    private static final String DYNAMIC_PRICING_ENABLED = "dynamic-pricing.enabled";
    private static final String DYNAMIC_PRICING_FLUCTUATION = "dynamic-pricing.daily-fluctuation-percent";
    private static final String DYNAMIC_PRICING_SAVE_INTERVAL = "dynamic-pricing.save-interval-minutes";
    private static final String SHOP_SECTIONS = "shop-sections";
    private static final String MESSAGES_PREFIX = "messages.prefix";

    public ConfigManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public boolean isDynamicPricingEnabled() {
        return this.config.getBoolean(DYNAMIC_PRICING_ENABLED, false);
    }

    public double getDynamicFluctuationPercent() {
        return this.config.getDouble(DYNAMIC_PRICING_FLUCTUATION, 5.0);
    }

    public long getSaveIntervalMinutes() {
        return this.config.getLong(DYNAMIC_PRICING_SAVE_INTERVAL, 10L);
    }

    public String getPrefix() {
        return this.config.getString(MESSAGES_PREFIX, "<dark_gray>[<gradient:#00ff00:#00ffff>ShopEngine</gradient>]</dark_gray>");
    }

    public Map<String, ShopSection> loadShopSections() {
        HashMap<String, ShopSection> sections = new HashMap<String, ShopSection>();
        ConfigurationSection sectionConfig = this.config.getConfigurationSection(SHOP_SECTIONS);
        if (sectionConfig == null) {
            this.plugin.getLogger().warning("No shop sections found in config!");
            return sections;
        }
        for (String sectionKey : sectionConfig.getKeys(false)) {
            ConfigurationSection sectionData = sectionConfig.getConfigurationSection(sectionKey);
            if (sectionData == null) continue;
            try {
                ShopSection section = this.loadSection(sectionKey, sectionData);
                sections.put(sectionKey, section);
                this.plugin.getLogger().info("Loaded shop section: " + sectionKey);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load section '" + sectionKey + "': " + e.getMessage());
            }
        }
        return sections;
    }

    private ShopSection loadSection(String key, ConfigurationSection sectionData) {
        String displayName = sectionData.getString("display-name", key);
        Material icon = Material.matchMaterial((String)sectionData.getString("icon", "CHEST"));
        int slot = sectionData.getInt("slot", 0);
        int page = sectionData.getInt("page", 1) - 1;
        ArrayList<ShopItem> items = new ArrayList<ShopItem>();
        ConfigurationSection itemsConfig = sectionData.getConfigurationSection("items");
        if (itemsConfig != null) {
            for (String itemKey : itemsConfig.getKeys(false)) {
                ConfigurationSection itemData = itemsConfig.getConfigurationSection(itemKey);
                if (itemData == null) continue;
                try {
                    ShopItem shopItem = this.loadItem(itemKey, itemData);
                    items.add(shopItem);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to load item '" + itemKey + "' in section '" + key + "': " + e.getMessage());
                }
            }
        }
        return new ShopSection(key, displayName, icon, slot, page, items);
    }

    private ShopItem loadItem(String key, ConfigurationSection itemData) {
        Material material = Material.matchMaterial((String)itemData.getString("material"));
        if (material == null) {
            throw new IllegalArgumentException("Invalid material: " + itemData.getString("material"));
        }
        String displayName = itemData.getString("display-name", "");
        int slot = itemData.getInt("slot");
        int page = itemData.getInt("page", 1) - 1;
        int amount = itemData.getInt("amount", 1);
        double buyPrice = itemData.getDouble("buy-price", -1.0);
        double sellPrice = itemData.getDouble("sell-price", -1.0);
        int stock = itemData.getInt("stock", -1);
        List lore = itemData.getStringList("lore");
        int customModelData = itemData.getInt("custom-model-data", -1);
        return new ShopItem(key, material, displayName, lore, slot, page, amount, buyPrice, sellPrice, stock, customModelData);
    }

    public Set<String> getSectionKeys() {
        ConfigurationSection sectionConfig = this.config.getConfigurationSection(SHOP_SECTIONS);
        return sectionConfig != null ? sectionConfig.getKeys(false) : Collections.emptySet();
    }

    public void addItemToSection(String sectionKey, String itemKey, ShopItem item) {
        String path = "shop-sections." + sectionKey + ".items." + itemKey;
        this.config.set(path + ".material", (Object)item.getMaterial().name());
        this.config.set(path + ".display-name", (Object)item.getDisplayName());
        this.config.set(path + ".slot", (Object)item.getSlot());
        this.config.set(path + ".page", (Object)(item.getPage() + 1));
        this.config.set(path + ".amount", (Object)item.getAmount());
        this.config.set(path + ".buy-price", (Object)item.getBuyPrice());
        this.config.set(path + ".sell-price", (Object)item.getSellPrice());
        this.config.set(path + ".stock", (Object)item.getStock());
        this.config.set(path + ".custom-model-data", (Object)item.getCustomModelData());
        this.config.set(path + ".lore", item.getLore());
        this.plugin.saveConfig();
    }
}

