/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.commands;

import java.util.HashMap;
import java.util.Map;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.gui.HistoryGUI;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShopCommand
implements CommandExecutor {
    private final ShopEngine plugin;

    public ShopCommand(ShopEngine plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "player-only");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getShopManager().openShop(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender, args);
                break;
            }
            case "resetprice": {
                this.handleResetPrice(sender, args);
                break;
            }
            case "balance": {
                this.handleBalance(sender, player);
                break;
            }
            case "help": {
                this.handleHelp(sender);
                break;
            }
            case "history": {
                if (!sender.hasPermission("shopengine.history")) {
                    this.sendMessage(sender, "no-permission");
                    return true;
                }
                new HistoryGUI(this.plugin, player).open();
                break;
            }
            default: {
                this.sendMessage(sender, "commands.unknown");
            }
        }
        return true;
    }

    private void handleReload(CommandSender sender, String[] args) {
        String target;
        if (!sender.hasPermission("shopengine.reload")) {
            this.sendMessage(sender, "no-permission");
            return;
        }
        switch (target = args.length > 1 ? args[1].toLowerCase() : "all") {
            case "all": {
                this.plugin.getConfigManager().reload();
                this.plugin.getMessageManager().reload();
                this.plugin.getSectionManager().reload();
                this.plugin.getItemManager().reload();
                this.plugin.getShopManager().loadShop();
                this.sendMessage(sender, "commands.reload-success");
                break;
            }
            case "config": {
                this.plugin.getConfigManager().reload();
                this.sendMessage(sender, "commands.reload-config");
                break;
            }
            case "messages": {
                this.plugin.getMessageManager().reload();
                this.sendMessage(sender, "commands.reload-messages");
                break;
            }
            case "sections": {
                this.plugin.getSectionManager().reload();
                this.plugin.getShopManager().loadShop();
                this.sendMessage(sender, "commands.reload-sections");
                break;
            }
            case "items": {
                this.plugin.getItemManager().reload();
                this.plugin.getShopManager().loadShop();
                this.sendMessage(sender, "commands.reload-items");
                break;
            }
            default: {
                this.sendMessage(sender, "commands.reload-unknown");
            }
        }
    }

    private void handleResetPrice(CommandSender sender, String[] args) {
        if (!sender.hasPermission("shopengine.resetprice")) {
            this.sendMessage(sender, "no-permission");
            return;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "commands.resetprice-usage");
            return;
        }
        this.plugin.getDynamicPricingManager().resetPrice(args[1]);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", args[1]);
        this.sendMessage(sender, "commands.resetprice-success", placeholders);
    }

    private void handleBalance(CommandSender sender, Player player) {
        if (!sender.hasPermission("shopengine.balance")) {
            this.sendMessage(sender, "no-permission");
            return;
        }
        double balance = this.plugin.getEconomyManager().getBalance(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("balance", String.valueOf(balance));
        this.sendMessage(sender, "economy.balance", placeholders);
    }

    private void handleHelp(CommandSender sender) {
        this.sendMessage(sender, "commands.help.header");
        this.sendMessage(sender, "commands.help.shop");
        this.sendMessage(sender, "commands.help.balance");
        this.sendMessage(sender, "commands.help.reload");
        this.sendMessage(sender, "commands.help.resetprice");
        this.sendMessage(sender, "commands.help.history");
        this.sendMessage(sender, "commands.help.help");
    }

    private void sendMessage(CommandSender sender, String key) {
        String msg = this.plugin.getMessageManager().getMessage(key);
        sender.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }

    private void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        String msg = this.plugin.getMessageManager().getMessage(key, placeholders);
        sender.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }
}

