/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.warp.api;

import com.serveressentials.api.warp.WarpAPI;
import com.serveressentials.api.warp.WarpData;
import com.serveressentials.api.warp.WarpLocation;
import com.serveressentials.api.warp.WarpSettings;
import com.serveressentials.api.warp.event.WarpCreateEvent;
import com.serveressentials.api.warp.event.WarpDeleteEvent;
import com.serveressentials.api.warp.event.WarpTeleportEvent;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.WarpConfig;
import net.godlycow.org.warp.WarpManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class WarpAPIImpl
implements WarpAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final WarpConfig config;
    @NotNull
    private final WarpManager manager;

    public WarpAPIImpl(@NotNull EssC plugin, @NotNull WarpConfig config, @NotNull WarpManager manager) {
        this.plugin = plugin;
        this.config = config;
        this.manager = manager;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportToWarp(@NotNull Player player, @NotNull String warpName) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<Optional<WarpData>> warpDataOpt = Optional.ofNullable(this.getWarp(warpName).join());
            if (warpDataOpt.isEmpty()) {
                return false;
            }
            WarpData warpData = warpDataOpt.get().orElse(null);
            if (warpData == null) {
                return false;
            }
            Location location = new Location(Bukkit.getWorld((String)warpData.getLocation().getWorld()), warpData.getLocation().getX(), warpData.getLocation().getY(), warpData.getLocation().getZ(), warpData.getLocation().getYaw(), warpData.getLocation().getPitch());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.teleport(location);
                Bukkit.getPluginManager().callEvent((Event)new WarpTeleportEvent(player, warpData));
            });
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> createWarp(@NotNull String name, @NotNull Location location, @NotNull UUID creator) {
        return CompletableFuture.supplyAsync(() -> {
            WarpLocation warpLocation = new WarpLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            WarpData warpData = new WarpData(name, warpLocation, creator);
            this.manager.addWarp(name, location, creator).join();
            Player creatorPlayer = Bukkit.getPlayer((UUID)creator);
            if (creatorPlayer != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new WarpCreateEvent(creatorPlayer, warpData)));
            }
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> deleteWarp(@NotNull String name, @NotNull Player deleter) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<Optional<WarpData>> warpDataOpt = Optional.ofNullable(this.getWarp(name).join());
            if (warpDataOpt.isEmpty()) {
                return false;
            }
            WarpData warpData = warpDataOpt.get().orElse(null);
            if (warpData == null) {
                return false;
            }
            this.manager.removeWarp(name).join();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new WarpDeleteEvent(deleter, name, deleter.getUniqueId())));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<WarpData>> getWarp(@NotNull String name) {
        return this.manager.getWarp(name).thenApply(locationOpt -> {
            if (locationOpt.isEmpty()) {
                return Optional.empty();
            }
            UUID creator = this.manager.getCreator(name).join().orElse(UUID.randomUUID());
            return ((Optional)locationOpt.get()).map(loc -> {
                WarpLocation warpLocation = new WarpLocation(loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
                return new WarpData(name, warpLocation, creator);
            });
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, WarpLocation>> getAllWarps() {
        return this.manager.getAllWarps().thenApply(warps -> warps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Location loc = (Location)entry.getValue();
            return new WarpLocation(loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        })));
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> getWarpCountForPlayer(@NotNull UUID playerId) {
        return this.manager.getWarpCountByCreator(playerId).thenApply(l -> (int)l);
    }

    @Override
    public int getMaxWarpsForPlayer(@NotNull Player player) {
        return this.manager.getMaxWarpsForPlayer(player);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> warpExists(@NotNull String name) {
        return this.manager.exists(name);
    }

    @Override
    @NotNull
    public WarpSettings getSettings() {
        return new WarpSettings(this.config.cooldown, this.config.defaultMaxWarps);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.plugin.getLogger().info("[ServerEssentials] Warp configuration reloaded");
        });
    }
}

