/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.warp;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.WarpConfig;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.warp.storage.WarpStorage;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WarpManager {
    private final WarpStorage storage;
    private final WarpConfig config;
    private final PlayerLanguageManager langManager;

    public WarpManager(WarpStorage storage, WarpConfig config, PlayerLanguageManager langManager) {
        this.storage = storage;
        this.config = config;
        this.langManager = langManager;
    }

    public CompletableFuture<Void> addWarp(String name, Location loc, UUID creator) {
        return this.storage.addWarp(name, loc, creator);
    }

    public CompletableFuture<Void> removeWarp(String name) {
        return this.storage.removeWarp(name);
    }

    public CompletableFuture<Optional<Optional<Location>>> getWarp(String name) {
        return this.storage.getWarp(name);
    }

    public CompletableFuture<Map<String, Location>> getAllWarps() {
        return this.storage.getAllWarps();
    }

    public CompletableFuture<Optional<UUID>> getCreator(String name) {
        return this.storage.getCreator(name);
    }

    public CompletableFuture<Boolean> exists(String name) {
        return this.storage.exists(name);
    }

    public CompletableFuture<Integer> getWarpCountByCreator(UUID creator) {
        return this.storage.getWarpCountByCreator(creator).thenApply(Long::intValue);
    }

    public int getMaxWarpsForPlayer(Player player) {
        return this.config.getMaxWarpsForPlayer(player);
    }

    public Duration getCooldown() {
        return this.config.cooldown;
    }
}

