/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.util.item;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;
    private final List<Component> lore = new ArrayList<Component>();

    private ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilder(material);
    }

    public ItemBuilder name(Component name) {
        this.meta.displayName(name);
        return this;
    }

    public ItemBuilder loreLine(Component line) {
        this.lore.add(line);
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder hideFlags() {
        this.meta.addItemFlags(ItemFlag.values());
        return this;
    }

    public ItemStack build() {
        if (!this.lore.isEmpty()) {
            this.meta.lore(this.lore);
        }
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

