/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.tpa.trigger;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.tpa.TPAConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class TPAListener
implements Listener {
    private final TPAConfig config;
    private final PlayerLanguageManager langManager;
    private final Map<UUID, Integer> warmupTasks = new ConcurrentHashMap<UUID, Integer>();

    public TPAListener(TPAConfig config, PlayerLanguageManager langManager) {
        this.config = config;
        this.langManager = langManager;
    }

    public void registerWarmupTask(UUID playerId, int taskId) {
        this.warmupTasks.put(playerId, taskId);
    }

    public void unregisterWarmupTask(UUID playerId) {
        this.warmupTasks.remove(playerId);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        boolean moved;
        if (!this.config.cancelOnMove) {
            return;
        }
        Player player = e.getPlayer();
        boolean blockLevel = this.config.blockMoveThresholdBlocks;
        boolean bl = blockLevel ? !e.getFrom().getBlock().equals((Object)e.getTo().getBlock()) : (moved = !e.getFrom().toVector().equals((Object)e.getTo().toVector()));
        if (!moved) {
            return;
        }
        Integer taskId = this.warmupTasks.get(player.getUniqueId());
        if (taskId != null) {
            Bukkit.getScheduler().cancelTask(taskId.intValue());
            this.warmupTasks.remove(player.getUniqueId());
            player.sendMessage(this.langManager.getMessageFor(player, "tpa.teleport-cancelled-move", "<red>Teleport cancelled due to movement.", LanguageManager.ComponentPlaceholder.of("{player}", player.getName())));
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.warmupTasks.remove(e.getPlayer().getUniqueId());
    }
}

