/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.tpa.api;

import com.serveressentials.api.tpa.TPAAPI;
import com.serveressentials.api.tpa.TPACosts;
import com.serveressentials.api.tpa.TPAPlayerData;
import com.serveressentials.api.tpa.TPARequestData;
import com.serveressentials.api.tpa.TPASettings;
import com.serveressentials.api.tpa.event.TPARequestAcceptEvent;
import com.serveressentials.api.tpa.event.TPARequestDenyEvent;
import com.serveressentials.api.tpa.event.TPARequestExpireEvent;
import com.serveressentials.api.tpa.event.TPARequestSendEvent;
import com.serveressentials.api.tpa.event.TPAToggleEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.tpa.TPAConfig;
import net.godlycow.org.tpa.model.TPARequest;
import net.godlycow.org.tpa.storage.TPAStorage;
import net.godlycow.org.tpa.trigger.TPAListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TPAAPIImpl
implements TPAAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final TPAConfig config;
    @NotNull
    private final TPAStorage storage;
    @NotNull
    private final TPAListener listener;

    public TPAAPIImpl(@NotNull EssC plugin, @NotNull TPAConfig config, @NotNull TPAStorage storage, @NotNull TPAListener listener) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        this.listener = listener;
    }

    @Override
    @NotNull
    public CompletableFuture<TPARequestData> sendRequest(@NotNull Player sender, @NotNull Player target, boolean here) {
        return CompletableFuture.supplyAsync(() -> {
            double cost;
            if (!this.validateRequest(sender, target)) {
                throw new IllegalArgumentException("Invalid request");
            }
            double d = cost = here ? this.config.costTpahere : this.config.costTpa;
            if (cost > 0.0) {
                // empty if block
            }
            TPARequest request = TPARequest.create(sender.getUniqueId(), target.getUniqueId(), here, cost);
            this.storage.saveRequest(request).join();
            TPARequestData requestData = new TPARequestData(request.senderId, request.targetId, request.here, request.cost, request.timestamp);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TPARequestSendEvent(sender, requestData)));
            this.storage.saveCooldown(sender.getUniqueId(), System.currentTimeMillis()).join();
            this.startTimeout(request);
            return requestData;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> acceptRequest(@NotNull Player target, @Nullable UUID senderId) {
        return this.storage.getActiveRequests(target.getUniqueId()).thenApply(requests -> {
            TPARequest request;
            if (requests.isEmpty()) {
                return false;
            }
            if (senderId != null) {
                request = this.findRequestBySender((List<TPARequest>)requests, senderId);
                if (request == null) {
                    return false;
                }
            } else {
                request = (TPARequest)requests.get(requests.size() - 1);
            }
            this.storage.removeRequest(request.senderId, request.targetId).join();
            this.acceptRequestInternal(request);
            TPARequestData requestData = new TPARequestData(request.senderId, request.targetId, request.here, request.cost, request.timestamp);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TPARequestAcceptEvent(target, requestData)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> denyRequest(@NotNull Player target, @Nullable UUID senderId) {
        return this.storage.getActiveRequests(target.getUniqueId()).thenApply(requests -> {
            TPARequest request;
            if (requests.isEmpty()) {
                return false;
            }
            if (senderId != null) {
                request = this.findRequestBySender((List<TPARequest>)requests, senderId);
                if (request == null) {
                    return false;
                }
            } else {
                request = (TPARequest)requests.get(requests.size() - 1);
            }
            this.storage.removeRequest(request.senderId, request.targetId).join();
            this.denyRequestInternal(request);
            TPARequestData requestData = new TPARequestData(request.senderId, request.targetId, request.here, request.cost, request.timestamp);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TPARequestDenyEvent(target, requestData)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> cancelRequest(@NotNull Player sender, @Nullable UUID targetId) {
        if (targetId == null) {
            return this.storage.getActiveRequestsForSender(sender.getUniqueId()).thenApply(requests -> {
                int count = requests.size();
                requests.forEach(req -> this.storage.removeRequest(req.senderId, req.targetId).join());
                return count;
            });
        }
        return ((CompletableFuture)this.storage.removeRequest(sender.getUniqueId(), targetId).thenApply(v -> 1)).exceptionally(ex -> 0);
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> sendRequestToAll(@NotNull Player sender) {
        return CompletableFuture.supplyAsync(() -> {
            double cost = this.config.costTpall;
            if (cost > 0.0) {
                // empty if block
            }
            int sent = 0;
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (target.equals((Object)sender) || this.isRequestsDisabled(target.getUniqueId())) continue;
                TPARequest request = TPARequest.create(sender.getUniqueId(), target.getUniqueId(), true, 0.0);
                this.storage.saveRequest(request).join();
                TPARequestData requestData = new TPARequestData(request.senderId, request.targetId, request.here, request.cost, request.timestamp);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TPARequestSendEvent(sender, requestData)));
                this.startTimeout(request);
                ++sent;
            }
            this.storage.saveCooldown(sender.getUniqueId(), System.currentTimeMillis()).join();
            return sent;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> toggleRequests(@NotNull Player player) {
        return this.storage.getToggle(player.getUniqueId()).thenApply(current -> {
            boolean newState = current == false;
            this.storage.setToggle(player.getUniqueId(), newState).join();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TPAToggleEvent(player, newState)));
            return newState;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<TPAPlayerData> getPlayerData(@NotNull UUID playerId) {
        return CompletableFuture.allOf(this.storage.getCooldown(playerId), this.storage.getToggle(playerId), this.storage.getActiveRequestsForSender(playerId), this.storage.getActiveRequests(playerId)).thenApply(v -> {
            long cooldown = this.storage.getCooldown(playerId).join();
            boolean toggle = this.storage.getToggle(playerId).join();
            int sent = this.storage.getActiveRequestsForSender(playerId).join().size();
            int received = this.storage.getActiveRequests(playerId).join().size();
            return new TPAPlayerData(playerId, cooldown, toggle, sent, received);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<TPARequestData>> getActiveRequests(@NotNull UUID targetId) {
        return this.storage.getActiveRequests(targetId).thenApply(requests -> requests.stream().map(req -> new TPARequestData(req.senderId, req.targetId, req.here, req.cost, req.timestamp)).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public TPASettings getSettings() {
        return new TPASettings(this.config.cooldown, this.config.timeout, this.config.warmup, this.config.teleportDelay, this.config.cancelOnMove, this.config.blockMoveThresholdBlocks, this.config.crossWorld, this.config.blockedWorlds, this.config.economyEnabled, this.config.particlesEnabled, this.config.particleType);
    }

    @Override
    @NotNull
    public TPACosts getCosts() {
        return new TPACosts(this.config.costTpa, this.config.costTpahere, this.config.costTpall, this.config.refundOnDeny, this.config.refundOnExpire);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.plugin.getLogger().info("[ServerEssentials] TPA configuration reloaded");
        });
    }

    private boolean validateRequest(Player sender, Player target) {
        if (this.config.blockedWorlds.contains(target.getWorld().getName())) {
            return false;
        }
        if (!this.config.crossWorld && !sender.getWorld().equals((Object)target.getWorld())) {
            return false;
        }
        return !this.isRequestsDisabled(target.getUniqueId());
    }

    private boolean isRequestsDisabled(UUID playerId) {
        return this.storage.getToggle(playerId).join();
    }

    private TPARequest findRequestBySender(List<TPARequest> requests, UUID senderId) {
        return requests.stream().filter(req -> req.senderId.equals(senderId)).findFirst().orElse(null);
    }

    private void startTimeout(TPARequest request) {
        int timeoutTicks = this.config.timeout * 20;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.storage.removeRequest(request.senderId, request.targetId).thenRun(() -> {
            Player sender = Bukkit.getPlayer((UUID)request.senderId);
            Player target = Bukkit.getPlayer((UUID)request.targetId);
            if (sender != null || target != null) {
                TPARequestData requestData = new TPARequestData(request.senderId, request.targetId, request.here, request.cost, request.timestamp);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (target != null) {
                        Bukkit.getPluginManager().callEvent((Event)new TPARequestExpireEvent(target, requestData));
                    }
                });
            }
        }), (long)timeoutTicks);
    }

    private void acceptRequestInternal(TPARequest request) {
        Player sender = Bukkit.getPlayer((UUID)request.senderId);
        Player target = Bukkit.getPlayer((UUID)request.targetId);
        if (sender == null || target == null) {
            return;
        }
        int warmupTicks = this.config.warmup * 20;
        int delayTicks = this.config.teleportDelay * 20;
        int totalDelay = warmupTicks + delayTicks;
        if (warmupTicks > 0) {
            this.listener.registerWarmupTask(sender.getUniqueId(), Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {}, (long)warmupTicks).getTaskId());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Location loc = request.here ? sender.getLocation() : target.getLocation();
            Player toTeleport = request.here ? target : sender;
            toTeleport.teleport(loc);
            this.listener.unregisterWarmupTask(sender.getUniqueId());
        }, (long)totalDelay);
    }

    private void denyRequestInternal(TPARequest request) {
        if (!this.config.economyEnabled || !this.config.refundOnDeny || request.cost > 0.0) {
            // empty if block
        }
    }
}

