/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.settings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.settings.SettingsButton;
import net.godlycow.org.settings.SettingsConfig;
import net.godlycow.org.settings.SettingsGUIHolder;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class SettingsGUI {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final SettingsConfig config;
    private final NamespacedKey buttonIdKey;
    private final NamespacedKey guiTypeKey;
    private final Set<Integer> availableSlots = new HashSet<Integer>();

    public SettingsGUI(Plugin plugin, PlayerLanguageManager langManager, SettingsConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.buttonIdKey = new NamespacedKey(plugin, "settings-button-id");
        this.guiTypeKey = new NamespacedKey(plugin, "settings-gui-type");
        this.calculateAvailableSlots();
    }

    private void calculateAvailableSlots() {
        for (int row = 1; row <= 4; ++row) {
            for (int col = 1; col <= 7; ++col) {
                this.availableSlots.add(row * 9 + col);
            }
        }
    }

    public void open(Player player, int page) {
        String title = this.langManager.getString(String.valueOf(player), this.config.getTitleKey(), "<gold>Settings", new LanguageManager.ComponentPlaceholder[0]);
        Inventory gui = Bukkit.createInventory((InventoryHolder)new SettingsGUIHolder(page), (int)this.config.getSize(), (String)title);
        if (this.config.shouldFillBorder()) {
            this.addBorderItems(gui, player);
        }
        List<SettingsButton> pageButtons = this.config.getButtonsForPage(page);
        for (int i = 0; i < pageButtons.size() && i < this.config.getItemsPerPage(); ++i) {
            SettingsButton button = pageButtons.get(i);
            if (button.hasPermission() && !player.hasPermission(button.getPermission())) continue;
            int slot = this.getSlotForPosition(i);
            gui.setItem(slot, this.createButtonItem(button, player));
        }
        if (this.config.isPaginationEnabled()) {
            this.addNavigationItems(gui, player, page);
        }
        this.addCloseButton(gui, player);
        player.openInventory(gui);
    }

    private void addBorderItems(Inventory gui, Player player) {
        ItemStack filler = this.createFillerItem(player);
        ItemStack border = this.createBorderItem(player);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, filler);
        }
        int rows = this.config.getRows();
        for (int slot = 0; slot < rows * 9; ++slot) {
            boolean isBorder;
            boolean bl = isBorder = slot < 9 || slot >= (rows - 1) * 9 || slot % 9 == 0 || slot % 9 == 8;
            if (!isBorder || gui.getItem(slot) == null) continue;
            gui.setItem(slot, border);
        }
    }

    private ItemStack createFillerItem(Player player) {
        ItemStack item = new ItemStack(this.config.getFillMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.empty());
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createBorderItem(Player player) {
        ItemStack item = new ItemStack(this.config.getBorderMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.empty());
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createButtonItem(SettingsButton button, Player player) {
        ItemStack item = new ItemStack(button.getMaterial());
        ItemMeta meta = item.getItemMeta();
        Component name = this.langManager.getMessageFor(player, button.getNameKey(), "<gold>" + button.getId(), new LanguageManager.ComponentPlaceholder[0]);
        meta.displayName(name);
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String loreKey : button.getLoreKeys()) {
            Component loreLine = this.langManager.getMessageFor(player, loreKey, "", new LanguageManager.ComponentPlaceholder[0]);
            if (loreLine.equals(Component.empty())) continue;
            lore.add(loreLine);
        }
        meta.lore(lore.isEmpty() ? null : lore);
        if (button.hasGlow()) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.buttonIdKey, PersistentDataType.STRING, (Object)button.getId());
        pdc.set(this.guiTypeKey, PersistentDataType.STRING, (Object)"settings");
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationItems(Inventory gui, Player player, int page) {
        PersistentDataContainer pdc;
        Component name;
        ItemMeta meta;
        if (this.config.hasPreviousPage(page)) {
            ItemStack prev = new ItemStack(this.config.getPreviousMaterial());
            meta = prev.getItemMeta();
            name = this.langManager.getMessageFor(player, this.config.getPreviousNameKey(), "<gold>Previous Page", new LanguageManager.ComponentPlaceholder[0]);
            meta.displayName(name);
            pdc = meta.getPersistentDataContainer();
            pdc.set(this.guiTypeKey, PersistentDataType.STRING, (Object)"settings-navigation");
            pdc.set(new NamespacedKey(this.plugin, "navigation-type"), PersistentDataType.STRING, (Object)"previous");
            prev.setItemMeta(meta);
            gui.setItem(this.config.getPreviousSlot(), prev);
        }
        if (this.config.hasNextPage(page)) {
            ItemStack next = new ItemStack(this.config.getNextMaterial());
            meta = next.getItemMeta();
            name = this.langManager.getMessageFor(player, this.config.getNextNameKey(), "<gold>Next Page", new LanguageManager.ComponentPlaceholder[0]);
            meta.displayName(next.displayName());
            pdc = meta.getPersistentDataContainer();
            pdc.set(this.guiTypeKey, PersistentDataType.STRING, (Object)"settings-navigation");
            pdc.set(new NamespacedKey(this.plugin, "navigation-type"), PersistentDataType.STRING, (Object)"next");
            next.setItemMeta(meta);
            gui.setItem(this.config.getNextSlot(), next);
        }
        ItemStack indicator = new ItemStack(Material.PAPER);
        meta = indicator.getItemMeta();
        name = this.langManager.getMessageFor(player, "commands.settings.gui.page-indicator", "<yellow>Page <white>{page}</white>/<white>{total}</white>", LanguageManager.ComponentPlaceholder.of("{page}", page + 1), LanguageManager.ComponentPlaceholder.of("{total}", this.config.getTotalPages()));
        meta.displayName(name);
        indicator.setItemMeta(meta);
        gui.setItem(49, indicator);
    }

    private void addCloseButton(Inventory gui, Player player) {
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta meta = close.getItemMeta();
        Component name = this.langManager.getMessageFor(player, "commands.settings.gui.close", "<red>Close", new LanguageManager.ComponentPlaceholder[0]);
        meta.displayName(name);
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.guiTypeKey, PersistentDataType.STRING, (Object)"settings-close");
        close.setItemMeta(meta);
        gui.setItem(53, close);
    }

    private int getSlotForPosition(int position) {
        int[] slots = this.availableSlots.stream().sorted().mapToInt(Integer::intValue).toArray();
        return position < slots.length ? slots[position] : 10;
    }
}

