/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.godlycow.org.settings.SettingsButton;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public final class SettingsConfig {
    private final Plugin plugin;
    private final List<SettingsButton> buttons = new ArrayList<SettingsButton>();
    private String titleKey;
    private int rows;
    private boolean fillBorder;
    private Material fillMaterial;
    private Material borderMaterial;
    private boolean paginationEnabled;
    private int itemsPerPage;
    private int previousSlot;
    private int nextSlot;
    private Material previousMaterial;
    private Material nextMaterial;
    private String previousNameKey;
    private String nextNameKey;

    public SettingsConfig(Plugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection settingsSection = config.getConfigurationSection("settings");
        if (settingsSection == null) {
            this.plugin.getLogger().warning("No 'settings' section found in config.yml");
            return;
        }
        this.buttons.clear();
        this.loadGUIConfig(settingsSection.getConfigurationSection("gui"));
        this.loadPaginationConfig(settingsSection.getConfigurationSection("pagination"));
        this.loadButtons(settingsSection.getConfigurationSection("buttons"));
    }

    private void loadGUIConfig(ConfigurationSection guiSection) {
        if (guiSection == null) {
            this.titleKey = "commands.settings.gui.title";
            this.rows = 6;
            this.fillBorder = true;
            this.fillMaterial = Material.GRAY_STAINED_GLASS_PANE;
            this.borderMaterial = Material.BLACK_STAINED_GLASS_PANE;
            return;
        }
        this.titleKey = guiSection.getString("title", "commands.settings.gui.title");
        this.rows = Math.max(1, Math.min(6, guiSection.getInt("rows", 6)));
        this.fillBorder = guiSection.getBoolean("fill-border", true);
        this.fillMaterial = Material.matchMaterial((String)guiSection.getString("fill-material", "GRAY_STAINED_GLASS_PANE"));
        this.borderMaterial = Material.matchMaterial((String)guiSection.getString("border-material", "BLACK_STAINED_GLASS_PANE"));
        if (this.fillMaterial == null) {
            this.fillMaterial = Material.GRAY_STAINED_GLASS_PANE;
        }
        if (this.borderMaterial == null) {
            this.borderMaterial = Material.BLACK_STAINED_GLASS_PANE;
        }
    }

    private void loadPaginationConfig(ConfigurationSection paginationSection) {
        if (paginationSection == null) {
            this.paginationEnabled = true;
            this.itemsPerPage = 21;
            this.previousSlot = 48;
            this.nextSlot = 50;
            this.previousMaterial = Material.ARROW;
            this.nextMaterial = Material.ARROW;
            this.previousNameKey = "commands.settings.gui.previous";
            this.nextNameKey = "commands.settings.gui.next";
            return;
        }
        this.paginationEnabled = paginationSection.getBoolean("enabled", true);
        this.itemsPerPage = Math.max(1, paginationSection.getInt("items-per-page", 21));
        this.previousSlot = paginationSection.getInt("previous-slot", 48);
        this.nextSlot = paginationSection.getInt("next-slot", 50);
        this.previousMaterial = Material.matchMaterial((String)paginationSection.getString("previous-material", "ARROW"));
        this.nextMaterial = Material.matchMaterial((String)paginationSection.getString("next-material", "ARROW"));
        this.previousNameKey = paginationSection.getString("previous-name", "commands.settings.gui.previous");
        this.nextNameKey = paginationSection.getString("next-name", "commands.settings.gui.next");
        if (this.previousMaterial == null) {
            this.previousMaterial = Material.ARROW;
        }
        if (this.nextMaterial == null) {
            this.nextMaterial = Material.ARROW;
        }
    }

    private void loadButtons(ConfigurationSection buttonsSection) {
        if (buttonsSection == null) {
            this.plugin.getLogger().warning("No 'settings.buttons' section found in config.yml");
            return;
        }
        for (String key : buttonsSection.getKeys(false)) {
            ConfigurationSection buttonSection = buttonsSection.getConfigurationSection(key);
            if (buttonSection == null) continue;
            try {
                String materialName = buttonSection.getString("material", "STONE");
                Material material = Material.matchMaterial((String)materialName);
                if (material == null) {
                    this.plugin.getLogger().warning("Invalid material '" + materialName + "' for button '" + key + "'");
                    continue;
                }
                SettingsButton button = new SettingsButton(key, buttonSection.getInt("position", this.buttons.size()), material, buttonSection.getString("name-key", "commands.settings.buttons." + key + ".name"), buttonSection.getStringList("lore-keys"), buttonSection.getBoolean("glow", false), buttonSection.getString("command", ""), buttonSection.getString("permission", null));
                this.buttons.add(button);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to load button '" + key + "'", e);
            }
        }
        this.buttons.sort((a, b) -> Integer.compare(a.getPosition(), b.getPosition()));
        this.plugin.getLogger().info("Loaded " + this.buttons.size() + " settings buttons");
    }

    public List<SettingsButton> getButtons() {
        return List.copyOf(this.buttons);
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows * 9;
    }

    public boolean shouldFillBorder() {
        return this.fillBorder;
    }

    public Material getFillMaterial() {
        return this.fillMaterial;
    }

    public Material getBorderMaterial() {
        return this.borderMaterial;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled && this.buttons.size() > this.itemsPerPage;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getPreviousSlot() {
        return this.previousSlot;
    }

    public int getNextSlot() {
        return this.nextSlot;
    }

    public Material getPreviousMaterial() {
        return this.previousMaterial;
    }

    public Material getNextMaterial() {
        return this.nextMaterial;
    }

    public String getPreviousNameKey() {
        return this.previousNameKey;
    }

    public String getNextNameKey() {
        return this.nextNameKey;
    }

    public List<SettingsButton> getButtonsForPage(int page) {
        if (!this.paginationEnabled) {
            return this.getButtons();
        }
        int start = page * this.itemsPerPage;
        int end = Math.min(start + this.itemsPerPage, this.buttons.size());
        if (start >= this.buttons.size()) {
            return List.of();
        }
        return this.buttons.subList(start, end);
    }

    public int getTotalPages() {
        if (!this.paginationEnabled) {
            return 1;
        }
        return (int)Math.ceil((double)this.buttons.size() / (double)this.itemsPerPage);
    }

    public boolean hasPreviousPage(int page) {
        return page > 0;
    }

    public boolean hasNextPage(int page) {
        return page < this.getTotalPages() - 1;
    }
}

