/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.sellgui.gui.trigger;

import java.util.Iterator;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.sellgui.gui.SellGUIManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SellGUIListener
implements Listener {
    private final SellGUIManager guiManager;
    private final PlayerLanguageManager langManager;
    private final MiniMessage mini = MiniMessage.miniMessage();

    public SellGUIListener(PlayerLanguageManager langManager, SellGUIManager guiManager) {
        this.langManager = langManager;
        this.guiManager = guiManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int slot;
        ItemStack cursor;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory topInv = event.getView().getTopInventory();
        if (topInv == null || !this.isSellGUI(event.getView().title().toString())) {
            return;
        }
        if (event.getCurrentItem() != null && this.guiManager.isDisplayItem(event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        if (event.getView().getBottomInventory() == event.getClickedInventory() && event.getCursor() != null && !event.getCursor().getType().isAir() && !this.guiManager.isSellable((cursor = event.getCursor()).getType())) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.not-sellable", "<red>\u274c This item cannot be sold!", new LanguageManager.ComponentPlaceholder[0]));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            event.setCancelled(true);
            return;
        }
        if (event.getClick().isShiftClick() && event.getClickedInventory() == topInv && this.guiManager.isBorderSlot(slot = event.getSlot(), topInv.getSize())) {
            event.setCancelled(true);
            return;
        }
        this.updateTotalValue(player, topInv);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        ItemStack item;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory topInv = event.getView().getTopInventory();
        if (topInv == null || !this.isSellGUI(event.getView().title().toString())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot2 = (Integer)iterator.next();
            if (!this.guiManager.isBorderSlot(slot2, topInv.getSize())) continue;
            event.setCancelled(true);
            return;
        }
        if (event.getRawSlots().stream().anyMatch(slot -> slot < topInv.getSize()) && (item = event.getOldCursor()) != null && !this.guiManager.isSellable(item.getType())) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.not-sellable", "<red>\u274c This item cannot be sold!", new LanguageManager.ComponentPlaceholder[0]));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            event.setCancelled(true);
        }
        this.updateTotalValue(player, topInv);
    }

    private void updateTotalValue(Player player, Inventory inv) {
        double totalValue = 0.0;
        for (int i = 0; i < inv.getSize(); ++i) {
            double price;
            ItemStack item;
            if (this.guiManager.isBorderSlot(i, inv.getSize()) || (item = inv.getItem(i)) == null || item.getType() == Material.AIR || this.guiManager.isDisplayItem(item) || !((price = this.guiManager.getSellPrice(item.getType())) > 0.0)) continue;
            totalValue += price * (double)item.getAmount();
        }
        this.guiManager.updateValueDisplay(player, inv, totalValue);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        if (inv == null || !this.isSellGUI(event.getView().title().toString())) {
            return;
        }
        this.guiManager.processSellAndReturnItems(player, inv);
    }

    private boolean isSellGUI(String title) {
        return title.contains("Sell Items");
    }
}

