/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.sellgui.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.godlycow.org.commands.config.SellConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.sellgui.storage.SellStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUIManager
implements Listener {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final SellStorage storage;
    private final SellConfig config;
    private final EconomyManager economyManager;
    private final Map<UUID, Double> pendingValues = new HashMap<UUID, Double>();
    private final DecimalFormat formatter = new DecimalFormat("#,##0.00");
    private final Set<Inventory> sellInventories = new HashSet<Inventory>();
    private final NamespacedKey displayKey;

    public double getSellPrice(Material material) {
        return this.config.getSellPrice(material);
    }

    public SellGUIManager(Plugin plugin, PlayerLanguageManager langManager, SellStorage storage, SellConfig config, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.economyManager = economyManager;
        this.displayKey = new NamespacedKey(plugin, "sellgui_display");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void openSellGUI(Player player) {
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.no-economy", "<red>\u2717 Economy system is not available. Please contact an administrator.", new LanguageManager.ComponentPlaceholder[0]));
            this.plugin.getLogger().warning("Attempted to open sell GUI for " + player.getName() + " but economy is disabled!");
            return;
        }
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.disabled", "<red>The sell GUI is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Component title = this.langManager.getMessageFor(player, "economy.sellgui.title", "<gold>\ud83d\udcb0 Sell Items", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory(null, (int)this.config.guiSize, (Component)title);
        this.createBorder(inv);
        this.createInfoPanel(player, inv);
        player.openInventory(inv);
        this.pendingValues.put(player.getUniqueId(), 0.0);
        this.sellInventories.add(inv);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 1.0f);
        this.plugin.getLogger().fine("Opened sell GUI for player: " + player.getName());
    }

    private void createBorder(Inventory inv) {
        ItemStack pane = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
        ItemMeta meta = pane.getItemMeta();
        if (meta != null) {
            meta.displayName(mini.deserialize(" "));
            meta.getPersistentDataContainer().set(this.displayKey, PersistentDataType.BYTE, (Object)1);
            pane.setItemMeta(meta);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            if (i >= 9 && i < inv.getSize() - 9 && i % 9 != 0 && i % 9 != 8) continue;
            inv.setItem(i, pane.clone());
        }
    }

    private void createInfoPanel(Player player, Inventory inv) {
        ItemStack emerald = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta meta = emerald.getItemMeta();
        if (meta != null) {
            meta.displayName(this.langManager.getMessageFor(player, "economy.sellgui.info.title", "<green><bold>\u2713 SELL ZONE", new LanguageManager.ComponentPlaceholder[0]));
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.subtitle", "<gray>Place items here to sell", new LanguageManager.ComponentPlaceholder[0]));
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.instruction", "<gray>Close inventory to process", new LanguageManager.ComponentPlaceholder[0]));
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "economy.sellgui.info.value-prefix", "<gold>Total Value: <yellow>$0.00", new LanguageManager.ComponentPlaceholder[0]));
            meta.lore(lore);
            meta.getPersistentDataContainer().set(this.displayKey, PersistentDataType.BYTE, (Object)1);
            emerald.setItemMeta(meta);
        }
        inv.setItem(inv.getSize() - 5, emerald);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int slot;
        if (!this.sellInventories.contains(event.getInventory())) {
            return;
        }
        if (event.getCurrentItem() != null && this.isDisplayItem(event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        if (event.getClick().isShiftClick() && event.getClickedInventory() == event.getInventory() && this.isBorderSlot(slot = event.getSlot(), event.getInventory().getSize())) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.sellInventories.contains(event.getInventory())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (!this.isBorderSlot(slot, event.getInventory().getSize())) continue;
            event.setCancelled(true);
            return;
        }
    }

    public boolean isBorderSlot(int slot, int inventorySize) {
        return slot < 9 || slot >= inventorySize - 9 || slot % 9 == 0 || slot % 9 == 8;
    }

    public boolean isDisplayItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(this.displayKey, PersistentDataType.BYTE);
    }

    public boolean isSellable(Material material) {
        return this.config.isSellable(material);
    }

    public void updateValueDisplay(Player player, Inventory inv, double totalValue) {
        List lore;
        ItemMeta meta;
        int centerSlot = inv.getSize() - 5;
        ItemStack item = inv.getItem(centerSlot);
        if (item != null && item.getType() == Material.EMERALD_BLOCK && (meta = item.getItemMeta()) != null && meta.hasLore() && (lore = meta.lore()).size() >= 4) {
            Component prefixComponent = this.langManager.getMessageFor(player, "economy.sellgui.info.value-prefix", "<gold>Total Value: <yellow>", new LanguageManager.ComponentPlaceholder[0]);
            String prefixText = ((String)mini.serialize(prefixComponent)).replaceAll("\\$0\\.00$", "");
            lore.set(3, mini.deserialize(prefixText + this.formatter.format(totalValue)));
            meta.lore(lore);
            item.setItemMeta(meta);
        }
    }

    public void processSellAndReturnItems(Player player, Inventory inv) {
        UUID uuid = player.getUniqueId();
        HashMap<Integer, ItemStack> itemsToReturn = new HashMap<Integer, ItemStack>();
        double totalValue = 0.0;
        int itemsSold = 0;
        this.plugin.getLogger().fine("Processing sell for player: " + player.getName());
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item2;
            if (this.isBorderSlot(i, inv.getSize()) || (item2 = inv.getItem(i)) == null || item2.getType() == Material.AIR || this.isDisplayItem(item2)) continue;
            Material mat = item2.getType();
            double pricePerItem = this.config.getSellPrice(mat);
            if (pricePerItem > 0.0) {
                int amount = item2.getAmount();
                double itemValue = pricePerItem * (double)amount;
                totalValue += itemValue;
                itemsSold += amount;
                this.storage.logSale(uuid, player.getName(), mat, amount, pricePerItem, itemValue).exceptionally(ex -> {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to log sale for " + player.getName(), (Throwable)ex);
                    return null;
                });
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.3f, 1.5f);
                continue;
            }
            itemsToReturn.put(i, item2.clone());
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.4f, 0.8f);
        }
        if (totalValue > 0.0) {
            EconomyResponse response = this.economyManager.deposit(player, totalValue);
            if (response.success()) {
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.0f);
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.sold-success", "<green><bold>\u2713 SOLD</bold> <white>{amount}x items</white> for <gold>{symbol}{price}", LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(itemsSold)), LanguageManager.ComponentPlaceholder.of("{symbol}", this.config.currencySymbol), LanguageManager.ComponentPlaceholder.of("{price}", this.formatter.format(totalValue))));
                this.plugin.getLogger().info(String.format("Player %s sold %d items for %s%.2f", player.getName(), itemsSold, this.config.currencySymbol, totalValue));
            } else {
                itemsToReturn.putAll(this.getRemainingSellableItems(inv));
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.transaction-failed", "<red>\u2717 Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", response.errorMessage)));
                this.plugin.getLogger().warning(String.format("Sell transaction failed for %s: %s", player.getName(), response.errorMessage));
            }
        }
        if (!itemsToReturn.isEmpty()) {
            HashMap leftOver = player.getInventory().addItem(itemsToReturn.values().toArray(new ItemStack[0]));
            if (!leftOver.isEmpty()) {
                leftOver.values().forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.inventory-full", "<yellow>\u26a0 Some items were dropped on the ground (inventory full)", new LanguageManager.ComponentPlaceholder[0]));
                this.plugin.getLogger().fine("Player " + player.getName() + " had items dropped due to full inventory");
            }
            if (totalValue == 0.0) {
                player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.returned-items", "<gray>Returned <white>{amount}x unsellable items</white> to your inventory", LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(itemsToReturn.size()))));
            }
        }
        this.pendingValues.remove(uuid);
        this.sellInventories.remove(inv);
        if (totalValue == 0.0 && itemsToReturn.isEmpty()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.no-items", "<gray>No items were sold", new LanguageManager.ComponentPlaceholder[0]));
        }
    }

    private Map<Integer, ItemStack> getRemainingSellableItems(Inventory inv) {
        HashMap<Integer, ItemStack> remaining = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item;
            if (this.isBorderSlot(i, inv.getSize()) || (item = inv.getItem(i)) == null || item.getType() == Material.AIR || this.isDisplayItem(item)) continue;
            remaining.put(i, item);
        }
        return remaining;
    }
}

