/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.sellgui.api;

import com.serveressentials.api.sellgui.SellGUIAPI;
import com.serveressentials.api.sellgui.SellGUILayout;
import com.serveressentials.api.sellgui.SellTransaction;
import com.serveressentials.api.sellgui.SellableItem;
import com.serveressentials.api.sellgui.event.SellGUIItemSellEvent;
import com.serveressentials.api.sellgui.event.SellGUIOpenEvent;
import com.serveressentials.api.sellgui.event.SellGUITransactionCompleteEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.SellConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.sellgui.gui.SellGUIManager;
import net.godlycow.org.sellgui.storage.SellStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class SellGUIAPIImpl
implements SellGUIAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final SellConfig config;
    @NotNull
    private final SellStorage storage;
    @NotNull
    private final SellGUIManager guiManager;
    @NotNull
    private final EconomyManager economyManager;

    public SellGUIAPIImpl(@NotNull EssC plugin, @NotNull SellConfig config, @NotNull SellStorage storage, @NotNull SellGUIManager guiManager, @NotNull EconomyManager economyManager) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        this.guiManager = guiManager;
        this.economyManager = economyManager;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> openSellGUI(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.config.enabled) {
                return false;
            }
            if (!this.economyManager.isEnabled()) {
                return false;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.guiManager.openSellGUI(player);
                Bukkit.getPluginManager().callEvent((Event)new SellGUIOpenEvent(player));
            });
            return true;
        });
    }

    @Override
    public boolean isSellable(@NotNull Material material) {
        return this.config.isSellable(material);
    }

    @Override
    public double getSellPrice(@NotNull Material material) {
        return this.config.getSellPrice(material);
    }

    @Override
    @NotNull
    public CompletableFuture<List<SellableItem>> getSellableItems() {
        return CompletableFuture.supplyAsync(() -> this.config.getSellPrices().entrySet().stream().map(entry -> new SellableItem((Material)entry.getKey(), (Double)entry.getValue())).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public SellGUILayout getLayout() {
        return new SellGUILayout(this.config.guiTitle, this.config.guiSize, this.config.currencySymbol);
    }

    @Override
    @NotNull
    public CompletableFuture<SellTransaction> processSellTransaction(@NotNull Player player, @NotNull Map<Material, Integer> items) {
        return CompletableFuture.supplyAsync(() -> {
            double totalValue = 0.0;
            int totalQuantity = 0;
            Material primaryMaterial = null;
            for (Map.Entry entry : items.entrySet()) {
                Material material = (Material)entry.getKey();
                int quantity = (Integer)entry.getValue();
                if (!this.isSellable(material)) continue;
                double price = this.getSellPrice(material);
                double itemValue = price * (double)quantity;
                totalValue += itemValue;
                totalQuantity += quantity;
                if (primaryMaterial == null) {
                    primaryMaterial = material;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new SellGUIItemSellEvent(player, material, quantity, price, itemValue)));
            }
            if (totalValue <= 0.0) {
                throw new IllegalArgumentException("No sellable items provided");
            }
            EconomyResponse response = this.economyManager.deposit(player, totalValue);
            if (!response.success()) {
                throw new RuntimeException("Economy transaction failed: ");
            }
            if (primaryMaterial == null) {
                primaryMaterial = Material.AIR;
            }
            SellTransaction transaction = new SellTransaction(player.getUniqueId(), player.getName(), primaryMaterial, totalQuantity, totalValue / (double)totalQuantity, totalValue, System.currentTimeMillis());
            this.logTransaction(transaction).join();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new SellGUITransactionCompleteEvent(player, transaction)));
            return transaction;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logTransaction(@NotNull SellTransaction transaction) {
        return this.storage.logSale(transaction.getPlayerId(), transaction.getPlayerName(), transaction.getMaterial(), transaction.getQuantity(), transaction.getPricePerItem(), transaction.getTotalPrice());
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled;
    }

    @Override
    @NotNull
    public String getCurrencySymbol() {
        return this.config.currencySymbol;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.plugin.getLogger().info("[ServerEssentials] SellGUI configuration reloaded");
        });
    }
}

