/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.scoreboard.runtime;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.godlycow.org.commands.config.ScoreboardConfig;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.scoreboard.runtime.ScoreboardUpdater;
import net.godlycow.org.scoreboard.storage.ScoreboardStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public final class ScoreboardListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ScoreboardConfig config;
    private final ScoreboardStorage storage;
    private final ScoreboardUpdater updater;

    public ScoreboardListener(Plugin plugin, PlayerLanguageManager langManager, ScoreboardConfig config, ScoreboardStorage storage, ScoreboardUpdater updater) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.storage = storage;
        this.updater = updater;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.config.enabled) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        CompletableFuture.runAsync(() -> {
            try {
                ((CompletableFuture)this.storage.loadPlayer(uuid).thenAccept(data -> Bukkit.getScheduler().runTask(this.plugin, () -> {
                    String layout;
                    if (!this.config.isWorldEnabled(player.getWorld().getName())) {
                        this.updater.clear(player);
                        return;
                    }
                    String string = layout = data.layout() != null ? data.layout() : this.config.getWorldLayout(player.getWorld().getName());
                    if (layout == null) {
                        layout = this.config.defaultLayout;
                    }
                    if (data.enabled()) {
                        this.updater.update(player, layout);
                    }
                }))).exceptionally(ex -> {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to load scoreboard data for " + player.getName(), (Throwable)ex);
                    return null;
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Critical error in scoreboard join handler", e);
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        if (!this.config.enabled) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        boolean enabled = this.storage.isEnabled(uuid);
        String layout = this.storage.getLayout(uuid);
        ((CompletableFuture)this.storage.savePlayer(uuid, enabled, layout).thenAccept(v -> this.storage.removeFromCache(uuid))).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save scoreboard data for " + player.getName(), (Throwable)ex);
            return null;
        });
        this.updater.clear(player);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (!this.config.enabled) {
            return;
        }
        Player player = event.getPlayer();
        String world = player.getWorld().getName();
        if (!this.config.isWorldEnabled(world)) {
            this.updater.clear(player);
            return;
        }
        String worldLayout = this.config.getWorldLayout(world);
        if (worldLayout != null) {
            this.updater.update(player, worldLayout);
        } else {
            this.updater.update(player);
        }
    }
}

