/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.scoreboard.api;

import com.serveressentials.api.scoreboard.ScoreboardAPI;
import com.serveressentials.api.scoreboard.ScoreboardLayout;
import com.serveressentials.api.scoreboard.ScoreboardPlayerData;
import com.serveressentials.api.scoreboard.event.ScoreboardLayoutChangeEvent;
import com.serveressentials.api.scoreboard.event.ScoreboardReloadEvent;
import com.serveressentials.api.scoreboard.event.ScoreboardToggleEvent;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.ScoreboardConfig;
import net.godlycow.org.scoreboard.runtime.ScoreboardUpdater;
import net.godlycow.org.scoreboard.storage.ScoreboardStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class ScoreboardAPIImpl
implements ScoreboardAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final ScoreboardConfig config;
    @NotNull
    private final ScoreboardStorage storage;
    @NotNull
    private final ScoreboardUpdater updater;

    public ScoreboardAPIImpl(@NotNull EssC plugin, @NotNull ScoreboardConfig config, @NotNull ScoreboardStorage storage, @NotNull ScoreboardUpdater updater) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        this.updater = updater;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> toggleScoreboard(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            UUID uuid = player.getUniqueId();
            boolean current = this.storage.isEnabled(uuid);
            boolean newState = !current;
            this.storage.setEnabled(uuid, newState).join();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new ScoreboardToggleEvent(player, newState)));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (newState) {
                    this.updater.update(player);
                } else {
                    this.updater.clear(player);
                }
            });
            return newState;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setLayout(@NotNull Player player, @NotNull String layout) {
        return CompletableFuture.runAsync(() -> {
            if (!this.config.layoutExists(layout)) {
                throw new IllegalArgumentException("Layout '" + layout + "' does not exist");
            }
            UUID uuid = player.getUniqueId();
            String previousLayout = this.storage.getLayout(uuid);
            this.storage.setLayout(uuid, layout).join();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new ScoreboardLayoutChangeEvent(player, layout, previousLayout)));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updater.update(player, layout));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            Bukkit.getOnlinePlayers().forEach(this.updater::updateAsync);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getOnlinePlayers().forEach(player -> Bukkit.getPluginManager().callEvent((Event)new ScoreboardReloadEvent((Player)player))));
        });
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled;
    }

    @Override
    @NotNull
    public CompletableFuture<ScoreboardPlayerData> getPlayerData(@NotNull Player player) {
        return this.storage.loadPlayer(player.getUniqueId()).thenApply(storageData -> new ScoreboardPlayerData(storageData.enabled(), storageData.layout(), storageData.lastUpdate(), storageData.joinTime()));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ScoreboardLayout>> getLayouts() {
        return CompletableFuture.supplyAsync(() -> this.config.getLayoutNames().stream().map(this.config::getLayout).map(layout -> new ScoreboardLayout(layout.title(), layout.lines(), layout.maxLines())).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<ScoreboardLayout>> getLayout(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.config.layoutExists(name)) {
                return Optional.empty();
            }
            ScoreboardConfig.Layout layout = this.config.getLayout(name);
            return Optional.of(new ScoreboardLayout(layout.title(), layout.lines(), layout.maxLines()));
        });
    }
}

