/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.rules.trigger;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.config.RulesConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.rules.gui.RulesGUI;
import net.godlycow.org.rules.storage.RulesStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RulesListener
implements Listener {
    private final PlayerLanguageManager langManager;
    private final RulesStorage storage;
    private final RulesConfig config;
    private final RulesGUI gui;
    private final Plugin plugin;
    private static final ConcurrentHashMap<UUID, Boolean> pendingAcceptance = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> lastReopenTime = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Integer> spamCount = new ConcurrentHashMap();
    private static final int PREV_PAGE_SLOT = 46;
    private static final int NEXT_PAGE_SLOT = 52;
    private static final int INFO_SLOT = 49;

    public RulesListener(PlayerLanguageManager langManager, RulesStorage storage, RulesConfig config, Plugin plugin) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.plugin = plugin;
        this.gui = new RulesGUI(langManager, storage, config, plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.mustAccept()) {
            return;
        }
        Player player = event.getPlayer();
        this.storage.hasAcceptedRules(player.getUniqueId()).thenAccept(accepted -> {
            if (!accepted.booleanValue()) {
                pendingAcceptance.put(player.getUniqueId(), true);
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                    if (player.isOnline()) {
                        this.gui.showRules(player);
                    }
                }, 40L);
            }
        });
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "commands.rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        if (!title.equals(expectedLegacy)) {
            return;
        }
        Long lastOpen = lastReopenTime.get(player.getUniqueId());
        int spamAttempts = spamCount.getOrDefault(player.getUniqueId(), 0);
        long baseCooldown = 2000L;
        long maxCooldown = 10000L;
        long cooldown = Math.min(baseCooldown * (long)Math.pow(2.0, spamAttempts), maxCooldown);
        if (lastOpen != null && System.currentTimeMillis() - lastOpen < cooldown) {
            return;
        }
        if (lastOpen != null && System.currentTimeMillis() - lastOpen < 1000L) {
            spamCount.put(player.getUniqueId(), spamAttempts + 1);
        }
        if (this.config.forceAcceptance() && pendingAcceptance.containsKey(player.getUniqueId())) {
            this.storage.hasAcceptedRules(player.getUniqueId()).thenAccept(accepted -> {
                if (!accepted.booleanValue() && player.isOnline()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.close.cannot-close", "<red>\u26a0 You must accept the rules before playing!", new LanguageManager.ComponentPlaceholder[0]));
                    long reopenDelay = Math.max(40L, cooldown / 50L);
                    lastReopenTime.put(player.getUniqueId(), System.currentTimeMillis());
                    Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                        if (player.isOnline() && pendingAcceptance.containsKey(player.getUniqueId())) {
                            this.gui.showRules(player);
                        }
                    }, reopenDelay);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        pendingAcceptance.remove(playerId);
        lastReopenTime.remove(playerId);
        spamCount.remove(playerId);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "commands.rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        if (!title.equals(expectedLegacy)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        Material itemType = item.getType();
        if (slot == this.config.acceptButtonSlot() && itemType == Material.matchMaterial((String)this.config.acceptButtonMaterial())) {
            this.gui.handleAccept(player);
        } else if (slot == this.config.declineButtonSlot() && itemType == Material.matchMaterial((String)this.config.declineButtonMaterial())) {
            this.gui.handleDecline(player);
        } else if (this.config.enablePagination()) {
            if (slot == 46 && itemType == Material.ARROW) {
                this.gui.handlePageChange(player, false);
            } else if (slot == 52 && itemType == Material.ARROW) {
                this.gui.handlePageChange(player, true);
            }
        }
    }

    public static void removePending(UUID playerId) {
        pendingAcceptance.remove(playerId);
        spamCount.remove(playerId);
    }
}

