/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.rules.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.config.RulesConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.rules.storage.RulesStorage;
import net.godlycow.org.rules.trigger.RulesListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RulesGUI {
    private final PlayerLanguageManager langManager;
    private final RulesStorage storage;
    private final RulesConfig config;
    private final Plugin plugin;
    private static final int GUI_SIZE = 54;
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final Map<UUID, Integer> playerPageMap = new ConcurrentHashMap<UUID, Integer>();
    private static final int RULE_SLOTS_START = 10;
    private static final int RULE_SLOTS_END = 43;
    private static final int[] BORDER_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int PREV_PAGE_SLOT = 46;
    private static final int NEXT_PAGE_SLOT = 52;
    private static final int INFO_SLOT = 49;

    public RulesGUI(PlayerLanguageManager langManager, RulesStorage storage, RulesConfig config, Plugin plugin) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.plugin = plugin;
    }

    public void showRules(Player player) {
        this.showRules(player, 0);
    }

    private void showRules(Player player, int page) {
        if (this.isViewingRules(player)) {
            return;
        }
        this.playerPageMap.put(player.getUniqueId(), page);
        this.storage.getAllRules().thenAccept(rules -> {
            if (rules.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.rules.gui.no-rules", "<red>No rules are currently configured.", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            Inventory inv = this.createInventory(player);
            this.setupBorders(inv, player);
            this.setupInfoPanel(inv, player, rules.size(), page);
            if (this.config.enablePagination() && rules.size() > this.config.rulesPerPage()) {
                this.setupPaginationControls(inv, player, page, rules.size());
            }
            this.setupActionButtons(inv, player);
            this.setupRules(inv, player, (List<RulesStorage.Rule>)rules, page);
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                if (player.isOnline()) {
                    player.openInventory(inv);
                }
            });
        });
    }

    private Inventory createInventory(Player player) {
        Component titleComponent = this.langManager.getMessageFor(player, "commands.rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String legacyTitle = LegacyComponentSerializer.legacySection().serialize(titleComponent);
        return Bukkit.createInventory((InventoryHolder)player, (int)54, (String)legacyTitle);
    }

    private void setupBorders(Inventory inv, Player player) {
        Material borderMat = Material.matchMaterial((String)this.config.guiBorderMaterial());
        if (borderMat == null) {
            borderMat = Material.GRAY_STAINED_GLASS_PANE;
        }
        ItemStack border = this.createBorderItem(borderMat, player);
        for (int slot : BORDER_SLOTS) {
            inv.setItem(slot, border);
        }
    }

    private void setupInfoPanel(Inventory inv, Player player, int totalRules, int currentPage) {
        ItemStack info = new ItemStack(Material.OAK_SIGN);
        ItemMeta meta = info.getItemMeta();
        Component title = this.langManager.getMessageFor(player, "commands.rules.gui.info-title", "<gold><bold>\u2139 Server Rules", new LanguageManager.ComponentPlaceholder[0]);
        meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(title));
        ArrayList<String> lore = new ArrayList<String>();
        Component line1 = this.langManager.getMessageFor(player, "commands.rules.gui.info-line1", "<gray>Please read and accept", new LanguageManager.ComponentPlaceholder[0]);
        lore.add(LegacyComponentSerializer.legacySection().serialize(line1));
        Component line2 = this.langManager.getMessageFor(player, "commands.rules.gui.info-line2", "<gray>our community guidelines", new LanguageManager.ComponentPlaceholder[0]);
        lore.add(LegacyComponentSerializer.legacySection().serialize(line2));
        lore.add("");
        if (this.config.enablePagination() && totalRules > this.config.rulesPerPage()) {
            int totalPages = (int)Math.ceil((double)totalRules / (double)this.config.rulesPerPage());
            String pageInfo = LegacyComponentSerializer.legacySection().serialize(this.langManager.getMessageFor(player, "commands.rules.gui.page-info", "<yellow>Page <white>{current}</white> / {total}", LanguageManager.ComponentPlaceholder.of("{current}", currentPage + 1), LanguageManager.ComponentPlaceholder.of("{total}", totalPages)));
            lore.add(pageInfo);
        }
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        info.setItemMeta(meta);
        inv.setItem(49, info);
    }

    private void setupPaginationControls(Inventory inv, Player player, int page, int totalRules) {
        int totalPages = (int)Math.ceil((double)totalRules / (double)this.config.rulesPerPage());
        Material prevMat = Material.ARROW;
        ItemStack prev = new ItemStack(prevMat);
        ItemMeta prevMeta = prev.getItemMeta();
        Component prevTitle = this.langManager.getMessageFor(player, "commands.rules.gui.prev-page", page > 0 ? "<green>\u2190 Previous Page" : "<gray>\u2190 Previous Page", new LanguageManager.ComponentPlaceholder[0]);
        prevMeta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(prevTitle));
        if (page > 0) {
            prevMeta.setLore(Collections.singletonList(LegacyComponentSerializer.legacySection().serialize(this.langManager.getMessageFor(player, "commands.rules.gui.prev-page-lore", "<gray>Click to go back", new LanguageManager.ComponentPlaceholder[0]))));
        }
        prev.setItemMeta(prevMeta);
        inv.setItem(46, prev);
        Material nextMat = Material.ARROW;
        ItemStack next = new ItemStack(nextMat);
        ItemMeta nextMeta = next.getItemMeta();
        Component nextTitle = this.langManager.getMessageFor(player, "commands.rules.gui.next-page", page < totalPages - 1 ? "<green>Next Page \u2192" : "<gray>Next Page \u2192", new LanguageManager.ComponentPlaceholder[0]);
        nextMeta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(nextTitle));
        if (page < totalPages - 1) {
            nextMeta.setLore(Collections.singletonList(LegacyComponentSerializer.legacySection().serialize(this.langManager.getMessageFor(player, "commands.rules.gui.next-page-lore", "<gray>Click to continue", new LanguageManager.ComponentPlaceholder[0]))));
        }
        next.setItemMeta(nextMeta);
        inv.setItem(52, next);
    }

    private void setupActionButtons(Inventory inv, Player player) {
        Material acceptMat = Material.matchMaterial((String)this.config.acceptButtonMaterial());
        if (acceptMat == null) {
            acceptMat = Material.LIME_CONCRETE;
        }
        ItemStack accept = new ItemStack(acceptMat);
        ItemMeta acceptMeta = accept.getItemMeta();
        Component acceptName = this.langManager.getMessageFor(player, "commands.rules.gui.accept-title", this.config.acceptButtonText(), new LanguageManager.ComponentPlaceholder[0]);
        acceptMeta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(acceptName));
        ArrayList<String> acceptLore = new ArrayList<String>();
        Component acceptLore1 = this.langManager.getMessageFor(player, "commands.rules.gui.accept-lore1", "<gray>Click to accept the rules", new LanguageManager.ComponentPlaceholder[0]);
        acceptLore.add(LegacyComponentSerializer.legacySection().serialize(acceptLore1));
        Component acceptLore2 = this.langManager.getMessageFor(player, "commands.rules.gui.accept-lore2", "<gray>and gain access to the server", new LanguageManager.ComponentPlaceholder[0]);
        acceptLore.add(LegacyComponentSerializer.legacySection().serialize(acceptLore2));
        acceptMeta.setLore(acceptLore);
        acceptMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        accept.setItemMeta(acceptMeta);
        inv.setItem(this.config.acceptButtonSlot(), accept);
        Material declineMat = Material.matchMaterial((String)this.config.declineButtonMaterial());
        if (declineMat == null) {
            declineMat = Material.RED_CONCRETE;
        }
        ItemStack decline = new ItemStack(declineMat);
        ItemMeta declineMeta = decline.getItemMeta();
        Component declineName = this.langManager.getMessageFor(player, "commands.rules.gui.decline-title", this.config.declineButtonText(), new LanguageManager.ComponentPlaceholder[0]);
        declineMeta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(declineName));
        ArrayList<String> declineLore = new ArrayList<String>();
        Component declineLore1 = this.langManager.getMessageFor(player, "commands.rules.gui.decline-lore1", "<gray>Click to decline and", new LanguageManager.ComponentPlaceholder[0]);
        declineLore.add(LegacyComponentSerializer.legacySection().serialize(declineLore1));
        Component declineLore2 = this.langManager.getMessageFor(player, "commands.rules.gui.decline-lore2", "<gray>leave the server", new LanguageManager.ComponentPlaceholder[0]);
        declineLore.add(LegacyComponentSerializer.legacySection().serialize(declineLore2));
        declineMeta.setLore(declineLore);
        declineMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        decline.setItemMeta(declineMeta);
        inv.setItem(this.config.declineButtonSlot(), decline);
    }

    private void setupRules(Inventory inv, Player player, List<RulesStorage.Rule> rules, int page) {
        Material fillerMat;
        Material ruleMat = Material.matchMaterial((String)this.config.ruleItemMaterial());
        if (ruleMat == null) {
            ruleMat = Material.PAPER;
        }
        int startIndex = page * this.config.rulesPerPage();
        int endIndex = Math.min(startIndex + this.config.rulesPerPage(), rules.size());
        List<Integer> ruleSlots = this.getRuleDisplaySlots();
        for (int i = startIndex; i < endIndex; ++i) {
            RulesStorage.Rule rule = rules.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= ruleSlots.size()) break;
            ItemStack ruleItem = this.createRuleItem(player, rule, ruleMat);
            inv.setItem(ruleSlots.get(slotIndex).intValue(), ruleItem);
        }
        if ((fillerMat = Material.matchMaterial((String)this.config.guiFillerMaterial())) == null) {
            fillerMat = Material.LIGHT_GRAY_STAINED_GLASS_PANE;
        }
        ItemStack filler = this.createFillerItem(fillerMat, player);
        for (int i = endIndex - startIndex; i < ruleSlots.size(); ++i) {
            inv.setItem(ruleSlots.get(i).intValue(), filler);
        }
    }

    private List<Integer> getRuleDisplaySlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 7; ++col) {
                slots.add(10 + row * 9 + col);
            }
        }
        return slots;
    }

    private ItemStack createRuleItem(Player player, RulesStorage.Rule rule, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        Component title = ((TextComponent)Component.text("Rule #" + (rule.orderIndex() + 1)).color(TextColor.color(16767334))).decorate(TextDecoration.BOLD);
        meta.displayName(title);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").color(TextColor.color(0xFFBF00)));
        lore.add(Component.empty());
        Component ruleText = MINI_MESSAGE.deserialize(rule.text()).colorIfAbsent(TextColor.color(0xC0C0C0)).decoration(TextDecoration.ITALIC, false);
        lore.addAll(this.wrapComponent(ruleText, 45));
        lore.add(Component.empty());
        lore.add(Component.text("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").color(TextColor.color(0xFFBF00)));
        meta.lore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createBorderItem(Material material, Player player) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createFillerItem(Material material, Player player) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private String extractColorPrefix(String text) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < text.length() - 1 && (text.charAt(i) == '&' || text.charAt(i) == '\u00a7') && "0123456789abcdefklmnor".indexOf(text.charAt(i + 1)) >= 0; i += 2) {
            prefix.append(text.charAt(i)).append(text.charAt(i + 1));
        }
        return prefix.toString();
    }

    private List<String> wrapText(String text, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String cleanWord = word.replaceAll("[&\u00a7][0-9a-fklmnor]", "");
            if (currentLine.length() + cleanWord.length() > maxLength) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private boolean isViewingRules(Player player) {
        String currentTitle = player.getOpenInventory().getTitle();
        Component expectedTitle = this.langManager.getMessageFor(player, "commands.rules.gui.title", this.config.title(), new LanguageManager.ComponentPlaceholder[0]);
        String expectedLegacy = LegacyComponentSerializer.legacySection().serialize(expectedTitle);
        return currentTitle.equals(expectedLegacy);
    }

    public void handleAccept(Player player) {
        RulesListener.removePending(player.getUniqueId());
        player.closeInventory();
        ((CompletableFuture)((CompletableFuture)this.storage.getLatestVersion().thenCompose(version -> this.storage.acceptRules(player.getUniqueId(), (int)version))).thenAccept(v -> {
            Component successMsg = this.langManager.getMessageFor(player, "commands.rules.accept.success", "<green><bold>\u2714 You accepted the server rules!", new LanguageManager.ComponentPlaceholder[0]).decoration(TextDecoration.ITALIC, false);
            player.sendMessage(successMsg);
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to accept rules for " + player.getName() + ": " + ex.getMessage());
            return null;
        });
    }

    public void handleDecline(Player player) {
        RulesListener.removePending(player.getUniqueId());
        player.closeInventory();
        player.kick(this.langManager.getMessageFor(player, "commands.rules.decline.kick-message", this.config.kickMessage(), new LanguageManager.ComponentPlaceholder[0]));
    }

    public void handlePageChange(Player player, boolean next) {
        Integer currentPage = this.playerPageMap.get(player.getUniqueId());
        if (currentPage == null) {
            return;
        }
        this.storage.getAllRules().thenAccept(rules -> {
            int newPage;
            int totalPages = (int)Math.ceil((double)rules.size() / (double)this.config.rulesPerPage());
            int n = newPage = next ? currentPage + 1 : currentPage - 1;
            if (newPage >= 0 && newPage < totalPages) {
                this.showRules(player, newPage);
            }
        });
    }

    private List<Component> wrapComponent(Component component, int maxLineLength) {
        ArrayList<Component> lines = new ArrayList<Component>();
        String plain = PlainTextComponentSerializer.plainText().serialize(component);
        String[] words = plain.split(" ");
        StringBuilder current = new StringBuilder();
        for (String word : words) {
            if (current.length() + word.length() > maxLineLength) {
                lines.add(Component.text(current.toString()).style(component.style()));
                current = new StringBuilder(word);
                continue;
            }
            if (current.length() > 0) {
                current.append(" ");
            }
            current.append(word);
        }
        if (!current.isEmpty()) {
            lines.add(Component.text(current.toString()).style(component.style()));
        }
        return lines;
    }
}

