/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.rtp.storage;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.godlycow.org.database.DatabaseManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class RtpLocationStorage {
    private final DatabaseManager dbManager;
    private final String poolKey;
    private final Plugin plugin;
    private final ExecutorService asyncExecutor;

    public RtpLocationStorage(Plugin plugin, DatabaseManager dbManager, String poolKey) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.poolKey = poolKey;
        this.asyncExecutor = Executors.newFixedThreadPool(Math.min(4, Runtime.getRuntime().availableProcessors()), r -> {
            Thread t = new Thread(r, "RTP-Storage-Thread");
            t.setDaemon(true);
            return t;
        });
        this.initTable();
    }

    private void initTable() {
        String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "CREATE TABLE IF NOT EXISTS rtp_locations (\n    player_uuid VARCHAR(36) PRIMARY KEY,\n    player_name VARCHAR(36),\n    world VARCHAR(64),\n    x DOUBLE,\n    y DOUBLE,\n    z DOUBLE,\n    timestamp BIGINT\n)\n").orElse("CREATE TABLE IF NOT EXISTS rtp_locations (\n    player_uuid TEXT PRIMARY KEY,\n    player_name TEXT,\n    world TEXT,\n    x REAL,\n    y REAL,\n    z REAL,\n    timestamp INTEGER\n)\n");
        CompletableFuture.runAsync(() -> this.dbManager.executeUpdate(this.poolKey, sql, new Object[0]).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to create RTP table: " + ex.getMessage());
            return null;
        }), this.asyncExecutor);
    }

    public CompletableFuture<Optional<Location>> getRtpLocation(UUID playerId) {
        String sql = "SELECT world, x, y, z FROM rtp_locations WHERE player_uuid = ?";
        return this.dbManager.executeQuery(this.poolKey, sql, rs -> {
            if (rs.next()) {
                String worldName = rs.getString("world");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                World world = this.plugin.getServer().getWorld(worldName);
                if (world != null) {
                    return new Location(world, x, y, z);
                }
            }
            return null;
        }, playerId.toString());
    }

    public CompletableFuture<Void> saveRtpLocation(UUID playerId, String playerName, Location loc) {
        String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "INSERT INTO rtp_locations (player_uuid, player_name, world, x, y, z, timestamp)\nVALUES (?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    player_name=VALUES(player_name),\n    world=VALUES(world),\n    x=VALUES(x),\n    y=VALUES(y),\n    z=VALUES(z),\n    timestamp=VALUES(timestamp)\n").orElse("INSERT OR REPLACE INTO rtp_locations VALUES (?, ?, ?, ?, ?, ?, ?)");
        return this.dbManager.executeUpdate(this.poolKey, sql, playerId.toString(), playerName, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), System.currentTimeMillis());
    }
}

