/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.rtp.api;

import com.serveressentials.api.rtp.RtpAPI;
import com.serveressentials.api.rtp.RtpLocation;
import com.serveressentials.api.rtp.RtpWorldConfig;
import com.serveressentials.api.rtp.event.RtpLocationSaveEvent;
import com.serveressentials.api.rtp.event.RtpTeleportEvent;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.EssC;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.rtp.RtpConfig;
import net.godlycow.org.rtp.storage.RtpLocationStorage;
import net.godlycow.org.rtp.trigger.RtpListener;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class RtpAPIImpl
implements RtpAPI {
    private final EssC plugin;
    private final RtpLocationStorage rtpLocationStorage;
    private final RtpConfig rtpConfig;
    private final RtpListener rtpListener;
    private final PlayerLanguageManager langManager;
    private final ConcurrentHashMap<String, World> worldCache = new ConcurrentHashMap();

    public RtpAPIImpl(EssC plugin, RtpLocationStorage rtpLocationStorage, RtpConfig rtpConfig, RtpListener rtpListener, PlayerLanguageManager langManager) {
        this.plugin = plugin;
        this.rtpLocationStorage = rtpLocationStorage;
        this.rtpConfig = rtpConfig;
        this.rtpListener = rtpListener;
        this.langManager = langManager;
    }

    @Override
    public CompletableFuture<Boolean> randomTeleport(Player player) {
        return this.randomTeleport(player, player.getWorld());
    }

    @Override
    public CompletableFuture<Boolean> randomTeleport(Player player, World world) {
        if (!player.hasPermission("essc.command.rtp")) {
            return CompletableFuture.completedFuture(false);
        }
        return this.isRtpEnabled(world.getName()).thenCompose(enabled -> {
            if (!enabled.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.getRemainingCooldown(player.getUniqueId()).thenCompose(remaining -> {
                if (remaining > 0L) {
                    return CompletableFuture.completedFuture(false);
                }
                int minRadius = this.rtpConfig.getMinRadius(world.getName());
                int maxRadius = this.rtpConfig.getMaxRadius(world.getName());
                return this.findSafeLocation(player, world, minRadius, maxRadius).thenCompose(safeLocation -> {
                    if (safeLocation == null) {
                        CompletableFuture.runAsync(() -> player.sendMessage(this.langManager.getMessageFor(player, "commands.rtp.unsafe_location", "<red>Could not find a safe location to teleport to!", new LanguageManager.ComponentPlaceholder[0])));
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.completeTeleport(player, (Location)safeLocation, world).thenApply(v -> true);
                });
            });
        });
    }

    @Override
    public CompletableFuture<Boolean> openRtpGUI(Player player) {
        if (!player.hasPermission("essc.command.rtp")) {
            return CompletableFuture.completedFuture(false);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Component title = this.langManager.getMessageFor(player, "commands.rtp.gui.title", "RTP Menu", new LanguageManager.ComponentPlaceholder[0]);
            Inventory gui = Bukkit.createInventory(null, (int)9, (Component)title);
            gui.setItem(2, this.createGuiItem(player, Material.GRASS_BLOCK, "overworld"));
            gui.setItem(4, this.createGuiItem(player, Material.NETHERRACK, "nether"));
            gui.setItem(6, this.createGuiItem(player, Material.END_STONE, "end"));
            player.openInventory(gui);
        });
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Optional<RtpLocation>> getLastRtpLocation(UUID playerId) {
        return this.rtpLocationStorage.getRtpLocation(playerId).thenApply(opt -> opt.map(loc -> new RtpLocation(playerId, "Unknown", loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), System.currentTimeMillis())));
    }

    @Override
    public CompletableFuture<Void> saveRtpLocation(UUID playerId, Location location) {
        Player player = this.plugin.getServer().getPlayer(playerId);
        String playerName = player != null ? player.getName() : "Unknown";
        return this.rtpLocationStorage.saveRtpLocation(playerId, playerName, location).thenRun(() -> {
            if (player != null && player.isOnline()) {
                RtpLocation rtpLocation = new RtpLocation(playerId, player.getName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), System.currentTimeMillis());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new RtpLocationSaveEvent(player, rtpLocation)));
            }
        });
    }

    @Override
    public CompletableFuture<Long> getRemainingCooldown(UUID playerId) {
        return CompletableFuture.completedFuture(0L);
    }

    @Override
    public CompletableFuture<Optional<RtpWorldConfig>> getWorldConfig(String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            boolean enabled = this.rtpConfig.isWorldEnabled(worldName);
            int minRadius = this.rtpConfig.getMinRadius(worldName);
            int maxRadius = this.rtpConfig.getMaxRadius(worldName);
            int cooldown = this.rtpConfig.getCooldown(worldName);
            if (!enabled && minRadius == 0 && maxRadius == 0 && cooldown == 0) {
                return Optional.empty();
            }
            return Optional.of(new RtpWorldConfig(worldName, enabled, minRadius, maxRadius, cooldown));
        });
    }

    @Override
    public CompletableFuture<Boolean> isRtpEnabled(String worldName) {
        return CompletableFuture.supplyAsync(() -> this.rtpConfig.isWorldEnabled(worldName));
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("rtp.enabled", true);
    }

    @Override
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.rtpConfig.reload();
            this.worldCache.clear();
            this.plugin.getLogger().info("[ServerEssentials] RTP configuration reloaded");
        });
    }

    private CompletableFuture<Location> findSafeLocation(Player player, World world, int minRadius, int maxRadius) {
        return CompletableFuture.supplyAsync(() -> {
            Random random = new Random();
            int maxAttempts = world.getEnvironment() == World.Environment.NETHER ? 50 : 25;
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                Location result;
                int x = random.nextInt(maxRadius - minRadius + 1) + minRadius;
                int z = random.nextInt(maxRadius - minRadius + 1) + minRadius;
                if (random.nextBoolean()) {
                    x = -x;
                }
                if (random.nextBoolean()) {
                    z = -z;
                }
                if (!(world.getEnvironment() == World.Environment.NETHER ? (result = this.findSafeNetherLocation(world, x, z, random)) != null : (result = this.findSafeOverworldLocation(world, x, z)) != null)) continue;
                return result;
            }
            return null;
        });
    }

    private Location findSafeOverworldLocation(World world, int x, int z) {
        return CompletableFuture.supplyAsync(() -> {
            world.loadChunk(x >> 4, z >> 4, true);
            int y = world.getHighestBlockYAt(x, z) + 1;
            Location test = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            return this.isLocationSafeSync(test) ? test : null;
        }).join();
    }

    private Location findSafeNetherLocation(World world, int x, int z, Random random) {
        for (int i = 0; i < 15; ++i) {
            Location test;
            int y;
            int n = y = i == 0 ? random.nextInt(90) + 30 : 30 + i * 6;
            if (y > 120) {
                y = 120 - i % 15;
            }
            if (!this.isNetherLocationSafeSync(test = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5))) continue;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> world.loadChunk(x >> 4, z >> 4, true));
            return test;
        }
        return null;
    }

    private boolean isLocationSafeSync(Location loc) {
        World w = loc.getWorld();
        if (w == null) {
            return false;
        }
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        if (y < w.getMinHeight() + 1 || y > w.getMaxHeight() - 2) {
            return false;
        }
        if (!w.isChunkLoaded(x >> 4, z >> 4)) {
            return false;
        }
        try {
            Block feet = w.getBlockAt(x, y, z);
            Block head = w.getBlockAt(x, y + 1, z);
            Block ground = w.getBlockAt(x, y - 1, z);
            if (!feet.getType().isAir()) {
                return false;
            }
            if (!head.getType().isAir()) {
                return false;
            }
            return ground.getType().isSolid();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isNetherLocationSafeSync(Location loc) {
        World w = loc.getWorld();
        if (w == null || w.getEnvironment() != World.Environment.NETHER) {
            return false;
        }
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        if (y < w.getMinHeight() + 1 || y > w.getMaxHeight() - 2) {
            return false;
        }
        if (!w.isChunkLoaded(x >> 4, z >> 4)) {
            return false;
        }
        try {
            Block feet = w.getBlockAt(x, y, z);
            Block head = w.getBlockAt(x, y + 1, z);
            Block ground = w.getBlockAt(x, y - 1, z);
            if (!feet.getType().isAir()) {
                return false;
            }
            if (!head.getType().isAir()) {
                return false;
            }
            Material g = ground.getType();
            return g.isSolid() && !this.isUnsafeNetherMaterial(g);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isUnsafeNetherMaterial(Material mat) {
        return mat == Material.LAVA || mat == Material.MAGMA_BLOCK || mat == Material.FIRE;
    }

    private CompletableFuture<Void> completeTeleport(Player player, Location safeLocation, World world) {
        return CompletableFuture.runAsync(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Location fromLocation = player.getLocation();
            player.teleport(safeLocation);
            this.saveRtpLocation(player.getUniqueId(), safeLocation);
            RtpLocation rtpLocation = new RtpLocation(player.getUniqueId(), player.getName(), world.getName(), safeLocation.getX(), safeLocation.getY(), safeLocation.getZ(), System.currentTimeMillis());
            Bukkit.getPluginManager().callEvent((Event)new RtpTeleportEvent(player, rtpLocation, fromLocation, world.getName()));
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rtp.teleport_success", "<green>Teleported to <white>{world}</white>!", LanguageManager.ComponentPlaceholder.of("{world}", world.getName())));
        }));
    }

    private ItemStack createGuiItem(Player player, Material material, String worldKey) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, "rtp.gui." + worldKey + ".name", worldKey, new LanguageManager.ComponentPlaceholder[0]));
        meta.lore(this.langManager.getMessageList(player, "rtp.gui." + worldKey + ".lore"));
        item.setItemMeta(meta);
        return item;
    }
}

