/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.rtp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class RtpConfig {
    private final Plugin plugin;
    private final FileConfiguration config;
    private final Map<String, WorldConfig> worldConfigs = new HashMap<String, WorldConfig>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RtpConfig(Plugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.load();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.lock.writeLock().lock();
        try {
            this.worldConfigs.clear();
            if (!this.config.contains("rtp")) {
                this.config.createSection("rtp");
                this.config.set("rtp.example_world.enabled", (Object)true);
                this.config.set("rtp.example_world.min_radius", (Object)1000);
                this.config.set("rtp.example_world.max_radius", (Object)5000);
                this.config.set("rtp.example_world.cooldown_seconds", (Object)300);
                this.plugin.saveConfig();
            }
            for (String worldName : this.config.getConfigurationSection("rtp").getKeys(false)) {
                String path = "rtp." + worldName + ".";
                boolean enabled = this.config.getBoolean(path + "enabled", false);
                int min = this.config.getInt(path + "min_radius", 1000);
                int max = this.config.getInt(path + "max_radius", 5000);
                int cooldown = this.config.getInt(path + "cooldown_seconds", 300);
                this.worldConfigs.put(worldName, new WorldConfig(enabled, min, max, cooldown));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorldEnabled(String worldName) {
        this.lock.readLock().lock();
        try {
            WorldConfig wc = this.worldConfigs.get(worldName);
            boolean bl = wc != null && wc.enabled;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinRadius(String worldName) {
        this.lock.readLock().lock();
        try {
            WorldConfig wc = this.worldConfigs.get(worldName);
            int n = wc != null ? wc.minRadius : 1000;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRadius(String worldName) {
        this.lock.readLock().lock();
        try {
            WorldConfig wc = this.worldConfigs.get(worldName);
            int n = wc != null ? wc.maxRadius : 5000;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCooldown(String worldName) {
        this.lock.readLock().lock();
        try {
            WorldConfig wc = this.worldConfigs.get(worldName);
            int n = wc != null ? wc.cooldown : 300;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static class WorldConfig {
        public final boolean enabled;
        public final int minRadius;
        public final int maxRadius;
        public final int cooldown;

        public WorldConfig(boolean enabled, int minRadius, int maxRadius, int cooldown) {
            this.enabled = enabled;
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
            this.cooldown = cooldown;
        }
    }
}

