/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.reports.api;

import com.serveressentials.api.report.ReportAPI;
import com.serveressentials.api.report.ReportInfo;
import com.serveressentials.api.report.ReportStats;
import com.serveressentials.api.report.event.ReportAutoClearEvent;
import com.serveressentials.api.report.event.ReportClearEvent;
import com.serveressentials.api.report.event.ReportCreateEvent;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.impl.ReportCommand;
import net.godlycow.org.reports.ReportConfig;
import net.godlycow.org.reports.model.Report;
import net.godlycow.org.reports.storage.ReportStorage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReportAPIImpl
implements ReportAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final ReportStorage reportStorage;
    @NotNull
    private final ReportConfig reportConfig;
    @NotNull
    private final ReportCommand reportCommand;

    public ReportAPIImpl(@NotNull EssC plugin, @NotNull ReportStorage reportStorage, @NotNull ReportConfig reportConfig, @NotNull ReportCommand reportCommand) {
        this.plugin = plugin;
        this.reportStorage = reportStorage;
        this.reportConfig = reportConfig;
        this.reportCommand = reportCommand;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> submitReport(@NotNull Player reporter, @NotNull String targetName, @NotNull String reason) {
        return CompletableFuture.supplyAsync(() -> {
            long remainingCooldown = this.getRemainingCooldown(reporter.getUniqueId()).join();
            if (remainingCooldown > 0L) {
                return false;
            }
            if (reason.length() > this.reportConfig.maxReasonLength) {
                return false;
            }
            OfflinePlayer target = this.plugin.getServer().getOfflinePlayerIfCached(targetName);
            if (!(target != null && (target.hasPlayedBefore() || target.isOnline()) || (target = this.plugin.getServer().getOfflinePlayer(targetName)).hasPlayedBefore() || target.isOnline())) {
                return false;
            }
            String reportId = UUID.randomUUID().toString().substring(0, 8);
            Report report = new Report(reportId, reporter.getUniqueId(), target.getUniqueId(), reason, System.currentTimeMillis(), true);
            this.reportStorage.addReport(report).join();
            this.reportStorage.saveCooldown(reporter.getUniqueId(), System.currentTimeMillis()).join();
            ReportInfo reportInfo = new ReportInfo(reportId, reporter.getUniqueId(), target.getUniqueId(), reason, System.currentTimeMillis(), true, reporter.getName(), target.getName());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new ReportCreateEvent(reporter, reportInfo)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> clearReport(@Nullable Player clearer, @NotNull String reportId) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<Report> reportOpt = this.reportStorage.getReport(reportId).join();
            if (!reportOpt.isPresent()) {
                return false;
            }
            Report report = reportOpt.get();
            this.reportStorage.clearReport(reportId).join();
            ReportInfo reportInfo = new ReportInfo(report.id(), report.reporterId(), report.targetId(), report.reason(), report.timestamp(), false, this.getPlayerName(report.reporterId()), this.getPlayerName(report.targetId()));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new ReportClearEvent(clearer, reportInfo, clearer != null)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<ReportInfo>> getReport(@NotNull String reportId) {
        return this.reportStorage.getReport(reportId).thenApply(opt -> opt.map(this::convertToReportInfo));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ReportInfo>> getAllReports() {
        return this.reportStorage.getAllReports().thenApply(reports -> reports.stream().map(this::convertToReportInfo).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ReportInfo>> getPendingReports() {
        return this.reportStorage.getPendingReports().thenCompose(reports -> {
            List reportInfos = reports.stream().map(this::convertToReportInfo).collect(Collectors.toList());
            return CompletableFuture.completedFuture(reportInfos);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<ReportStats> getReportStats() {
        return this.getAllReports().thenApply(allReports -> {
            List pending = allReports.stream().filter(ReportInfo::isPending).collect(Collectors.toList());
            List cleared = allReports.stream().filter(r -> !r.isPending()).collect(Collectors.toList());
            long oldestTimestamp = allReports.stream().mapToLong(ReportInfo::getTimestamp).min().orElse(0L);
            long newestTimestamp = allReports.stream().mapToLong(ReportInfo::getTimestamp).max().orElse(0L);
            return new ReportStats(allReports.size(), pending.size(), cleared.size(), oldestTimestamp, newestTimestamp);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Long> getRemainingCooldown(@NotNull UUID playerId) {
        return this.reportStorage.getCooldown(playerId).thenApply(lastUsed -> {
            if (lastUsed == 0L) {
                return 0L;
            }
            long now = System.currentTimeMillis();
            int cooldownMs = this.reportConfig.cooldown * 1000;
            long elapsed = now - lastUsed;
            long remaining = (long)cooldownMs - elapsed;
            return Math.max(0L, remaining / 1000L);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> autoClearReports(@Nullable Player clearer) {
        return CompletableFuture.supplyAsync(() -> {
            int autoClearDays = this.reportConfig.autoClearAfterDays;
            if (autoClearDays <= 0) {
                return 0;
            }
            long cutoffTime = System.currentTimeMillis() - (long)autoClearDays * 24L * 60L * 60L * 1000L;
            return (Integer)((CompletableFuture)this.getAllReports().thenCompose(allReports -> {
                List toClear = allReports.stream().filter(report -> report.getTimestamp() < cutoffTime && report.isPending()).collect(Collectors.toList());
                if (toClear.isEmpty()) {
                    return CompletableFuture.completedFuture(0);
                }
                List<CompletableFuture> clearFutures = toClear.stream().map(report -> this.clearReport(clearer, report.getId())).collect(Collectors.toList());
                return CompletableFuture.allOf(clearFutures.toArray(new CompletableFuture[0])).thenApply(v -> toClear.size());
            })).join();
        }).thenCompose(clearedCount -> {
            if (clearedCount > 0) {
                return this.getAllReports().thenApply(allReports -> {
                    List clearedReports = allReports.stream().filter(r -> !r.isPending()).collect(Collectors.toList());
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new ReportAutoClearEvent(clearedReports)));
                    return clearedCount;
                });
            }
            return CompletableFuture.completedFuture(clearedCount);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("reports.enabled", true);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.reportConfig.reload();
            this.plugin.getLogger().info("[ServerEssentials] Report configuration reloaded");
        });
    }

    @NotNull
    private ReportInfo convertToReportInfo(@NotNull Report report) {
        return new ReportInfo(report.id(), report.reporterId(), report.targetId(), report.reason(), report.timestamp(), report.pending(), this.getPlayerName(report.reporterId()), this.getPlayerName(report.targetId()));
    }

    @Nullable
    private String getPlayerName(@NotNull UUID playerId) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerId);
        return player.getName();
    }
}

