/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.nick.api;

import com.serveressentials.api.nick.NickAPI;
import com.serveressentials.api.nick.NickInfo;
import com.serveressentials.api.nick.NickValidationRules;
import com.serveressentials.api.nick.event.NickResetEvent;
import com.serveressentials.api.nick.event.NickSetEvent;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.NickConfig;
import net.godlycow.org.nick.NickManager;
import net.godlycow.org.nick.storage.NickStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NickAPIImpl
implements NickAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final NickStorage nickStorage;
    @NotNull
    private final NickConfig nickConfig;
    @NotNull
    private final NickManager nickManager;

    public NickAPIImpl(@NotNull EssC plugin, @NotNull NickStorage nickStorage, @NotNull NickConfig nickConfig, @NotNull NickManager nickManager) {
        this.plugin = plugin;
        this.nickStorage = nickStorage;
        this.nickConfig = nickConfig;
        this.nickManager = nickManager;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> setNickname(@NotNull Player player, @NotNull String nickname) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.validateNickname(player, nickname).join().booleanValue()) {
                return false;
            }
            UUID playerId = player.getUniqueId();
            String oldNickname = this.nickManager.getAllCachedNicks().getOrDefault(playerId, player.getName());
            long remainingCooldown = this.getRemainingCooldown(playerId).join();
            if (remainingCooldown > 0L) {
                return false;
            }
            int dailyChanges = this.getDailyChanges(playerId).join();
            if (this.nickConfig.maxChangesPerDay > 0 && dailyChanges >= this.nickConfig.maxChangesPerDay) {
                return false;
            }
            this.nickStorage.setNickname(playerId, nickname).join();
            if (this.nickConfig.maxChangesPerDay > 0) {
                this.nickStorage.incrementDailyChanges(playerId).join();
            }
            this.nickManager.applyNick(playerId, nickname);
            NickInfo nickInfo = new NickInfo(playerId, player.getName(), nickname, System.currentTimeMillis(), dailyChanges + 1);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new NickSetEvent(player, nickInfo, oldNickname)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> resetNickname(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            UUID playerId = player.getUniqueId();
            this.nickStorage.removeNickname(playerId).join();
            this.nickManager.removeNick(playerId);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new NickResetEvent(player, playerId, player.getName(), true)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> resetOtherNickname(@NotNull Player sender, @NotNull String targetName) {
        return CompletableFuture.supplyAsync(() -> {
            if (!sender.hasPermission("essc.command.nicks")) {
                return false;
            }
            @Nullable Player target = this.plugin.getServer().getPlayer(targetName);
            if (target == null) {
                return false;
            }
            UUID targetId = target.getUniqueId();
            this.nickStorage.removeNickname(targetId).join();
            this.nickManager.removeNick(targetId);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new NickResetEvent(sender, targetId, target.getName(), false)));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NickInfo>> getNickname(@NotNull UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            Map<UUID, String> cache = this.nickManager.getAllCachedNicks();
            if (cache.containsKey(playerId)) {
                String nickname2 = cache.get(playerId);
                Player player = this.plugin.getServer().getPlayer(playerId);
                if (player != null) {
                    return Optional.of(new NickInfo(playerId, player.getName(), nickname2, System.currentTimeMillis(), 0));
                }
            }
            return this.nickStorage.getNickname(playerId).join().map(nickname -> {
                Player player = this.plugin.getServer().getPlayer(playerId);
                if (player != null) {
                    return new NickInfo(playerId, player.getName(), (String)nickname, System.currentTimeMillis(), 0);
                }
                return null;
            });
        });
    }

    @Override
    @NotNull
    public List<NickInfo> getAllNicknames() {
        Map<UUID, String> cache = this.nickManager.getAllCachedNicks();
        return cache.entrySet().stream().map(entry -> {
            Player player = this.plugin.getServer().getPlayer((UUID)entry.getKey());
            if (player != null) {
                return new NickInfo((UUID)entry.getKey(), player.getName(), (String)entry.getValue(), System.currentTimeMillis(), 0);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public NickValidationRules getValidationRules() {
        return new NickValidationRules(this.nickConfig.minLength, this.nickConfig.maxLength, this.nickConfig.allowFormatting, this.nickConfig.allowReset, this.nickConfig.allowDuplicates, this.nickConfig.cooldown, this.nickConfig.maxChangesPerDay, this.nickConfig.blockedWords, this.nickConfig.blacklistPatterns);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> validateNickname(@NotNull Player player, @NotNull String nickname) {
        return CompletableFuture.supplyAsync(() -> {
            String stripped = this.stripFormatting(nickname);
            if (stripped.length() < this.nickConfig.minLength || stripped.length() > this.nickConfig.maxLength) {
                return false;
            }
            for (String string : this.nickConfig.blockedWords) {
                if (!stripped.toLowerCase().contains(string.toLowerCase())) continue;
                return false;
            }
            for (String string : this.nickConfig.blacklistPatterns) {
                try {
                    if (!Pattern.compile(string, 2).matcher(stripped).find()) continue;
                    return false;
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            if (!this.nickConfig.allowFormatting && this.containsFormatting(nickname)) {
                return false;
            }
            if (!this.nickConfig.allowDuplicates) {
                for (Map.Entry entry : this.nickManager.getAllCachedNicks().entrySet()) {
                    if (!((String)entry.getValue()).equalsIgnoreCase(nickname) || ((UUID)entry.getKey()).equals(player.getUniqueId())) continue;
                    return false;
                }
            }
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Long> getRemainingCooldown(@NotNull UUID playerId) {
        if (this.nickConfig.cooldown <= 0) {
            return CompletableFuture.completedFuture(0L);
        }
        return this.nickStorage.getNickname(playerId).thenCompose(opt -> {
            if (!opt.isPresent()) {
                return CompletableFuture.completedFuture(0L);
            }
            return CompletableFuture.completedFuture(0L);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> getDailyChanges(@NotNull UUID playerId) {
        String today = LocalDate.now().toString();
        return this.nickStorage.getDailyChanges(playerId, today).thenApply(opt -> opt.orElse(0));
    }

    @Override
    public boolean isEnabled() {
        return this.nickConfig.enabled;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.nickConfig.reload();
            this.nickManager.reloadAllNicks();
            this.plugin.getLogger().info("[ServerEssentials] Nickname configuration reloaded");
        });
    }

    @NotNull
    private String stripFormatting(@NotNull String input) {
        return input.replaceAll("<[^>]+>", "");
    }

    private boolean containsFormatting(@NotNull String input) {
        return input.contains("<") && input.contains(">");
    }
}

