/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.nick;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.nick.storage.NickStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class NickManager {
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final Map<UUID, String> nickCache = new HashMap<UUID, String>();
    private final NickStorage storage;
    private final Plugin plugin;

    public NickManager(Plugin plugin, NickStorage storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.loadOnlinePlayers();
    }

    private void loadOnlinePlayers() {
        Bukkit.getOnlinePlayers().forEach(player -> ((CompletableFuture)this.storage.getNickname(player.getUniqueId()).thenAccept(opt -> {
            if (opt.isPresent()) {
                this.applyNick(player.getUniqueId(), (String)opt.get());
                this.plugin.getLogger().info("Loaded nickname for " + player.getName() + ": " + (String)opt.get());
            }
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to load nickname for " + player.getName() + ": " + ex.getMessage());
            return null;
        }));
    }

    public void loadPlayerNickname(UUID playerId) {
        ((CompletableFuture)this.storage.getNickname(playerId).thenAccept(opt -> {
            if (opt.isPresent()) {
                this.applyNick(playerId, (String)opt.get());
                this.plugin.getLogger().info("Loaded nickname for player: " + (String)opt.get());
            }
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to load nickname for player " + String.valueOf(playerId) + ": " + ex.getMessage());
            return null;
        });
    }

    public void applyNick(UUID playerId, String nick) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return;
        }
        try {
            Object displayName = this.mini.deserialize(nick);
            player.displayName(displayName);
            player.playerListName(displayName);
            this.nickCache.put(playerId, nick);
            this.plugin.getLogger().fine("Applied nickname to " + player.getName() + ": " + nick);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to apply nickname '" + nick + "' to " + player.getName() + ": " + e.getMessage());
        }
    }

    public void removeNick(UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null) {
            TextComponent originalName = Component.text(player.getName());
            player.displayName((Component)originalName);
            player.playerListName((Component)originalName);
            this.plugin.getLogger().fine("Removed nickname from " + player.getName());
        }
        this.nickCache.remove(playerId);
        this.storage.removeNickname(playerId);
    }

    public void reloadAllNicks() {
        this.nickCache.clear();
        this.loadOnlinePlayers();
        this.plugin.getLogger().info("Reloaded all nicknames");
    }

    public Map<UUID, String> getAllCachedNicks() {
        return new HashMap<UUID, String>(this.nickCache);
    }
}

