/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.modules;

import java.util.Collections;
import java.util.List;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.modules.ModuleManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedCommand
implements CommandExecutor,
TabCompleter {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private final String moduleName;
    private final String commandName;
    private final CommandExecutor executor;
    private final TabCompleter completer;
    private final ModuleManager moduleManager;
    private final PlayerLanguageManager langManager;

    public WrappedCommand(String moduleName, String commandName, CommandExecutor executor, @Nullable TabCompleter completer, ModuleManager moduleManager, PlayerLanguageManager langManager) {
        this.moduleName = moduleName;
        this.commandName = commandName;
        this.executor = executor;
        this.completer = completer;
        this.moduleManager = moduleManager;
        this.langManager = langManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.moduleManager.canExecute(this.moduleName, this.commandName)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.module.disabled-message", "<red>\u2717 Command '/{cmd}' is disabled by server administrator.", LanguageManager.ComponentPlaceholder.of("{cmd}", this.commandName)));
            return true;
        }
        return this.executor.onCommand(sender, command, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (!this.moduleManager.canExecute(this.moduleName, this.commandName)) {
            return Collections.emptyList();
        }
        return this.completer != null ? this.completer.onTabComplete(sender, command, alias, args) : Collections.emptyList();
    }
}

