/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.modules;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.modules.Module;
import net.godlycow.org.modules.WrappedCommand;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class ModuleManager {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final Map<String, CommandRegistration> commandRegistrations = new HashMap<String, CommandRegistration>();
    private boolean loaded = false;

    public ModuleManager(JavaPlugin plugin, PlayerLanguageManager langManager) {
        this.plugin = plugin;
        this.langManager = langManager;
    }

    public void loadFromConfig() {
        this.modules.clear();
        this.commandRegistrations.clear();
        this.loaded = false;
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("modules");
        if (section == null) {
            this.plugin.getLogger().warning("No 'modules' section in config.yml");
            this.loaded = true;
            return;
        }
        int cmdCount = 0;
        for (String moduleName : section.getKeys(false)) {
            boolean enabled = section.getBoolean(moduleName + ".enabled", true);
            HashMap<String, Boolean> commands = new HashMap<String, Boolean>();
            ConfigurationSection cmdSection = section.getConfigurationSection(moduleName + ".commands");
            if (cmdSection != null) {
                for (String cmd : cmdSection.getKeys(false)) {
                    commands.put(cmd.toLowerCase(), cmdSection.getBoolean(cmd, true));
                    ++cmdCount;
                }
            }
            this.modules.put(moduleName.toLowerCase(), new Module(enabled, commands));
        }
        this.loaded = true;
        this.plugin.getLogger().info("Loaded " + this.modules.size() + " modules, " + cmdCount + " commands");
    }

    public void registerCommand(String moduleName, String commandName, CommandExecutor executor, @Nullable TabCompleter completer) {
        if (!this.loaded) {
            throw new IllegalStateException("Call loadFromConfig() first!");
        }
        PluginCommand cmd = this.plugin.getCommand(commandName);
        if (cmd == null) {
            this.plugin.getLogger().warning("Command /" + commandName + " not in plugin.yml");
            return;
        }
        this.commandRegistrations.put(commandName.toLowerCase(), new CommandRegistration(moduleName, (Command)cmd));
        if (this.isCommandEnabled(moduleName, commandName)) {
            cmd.setExecutor((CommandExecutor)new WrappedCommand(moduleName, commandName, executor, completer, this, this.langManager));
            cmd.setTabCompleter(completer);
            this.plugin.getLogger().fine("Command /" + commandName + " enabled");
        } else {
            this.unregisterCommand(commandName);
        }
    }

    private boolean isCommandEnabled(String moduleName, String commandName) {
        Module mod = this.modules.get(moduleName.toLowerCase());
        if (mod == null) {
            return true;
        }
        if (!mod.isEnabled()) {
            return false;
        }
        return mod.isCommandEnabled(commandName);
    }

    public void unregisterCommand(String commandName) {
        CommandRegistration reg = this.commandRegistrations.get(commandName.toLowerCase());
        if (reg == null) {
            return;
        }
        try {
            PluginCommand pc;
            CommandMap commandMap = this.getCommandMap();
            Map<String, Command> knownCommands = this.getKnownCommands(commandMap);
            Command current = knownCommands.get(commandName.toLowerCase());
            if (!(current instanceof PluginCommand) || (pc = (PluginCommand)current).getPlugin() != this.plugin) {
                return;
            }
            knownCommands.remove(commandName.toLowerCase());
            knownCommands.remove(this.plugin.getName().toLowerCase() + ":" + commandName.toLowerCase());
            for (String alias : current.getAliases()) {
                knownCommands.remove(alias.toLowerCase());
                knownCommands.remove(this.plugin.getName().toLowerCase() + ":" + alias.toLowerCase());
            }
            current.unregister(commandMap);
            this.plugin.getLogger().fine("Command /" + commandName + " unregistered");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to unregister /" + commandName, e);
        }
    }

    private CommandMap getCommandMap() throws Exception {
        Server server = this.plugin.getServer();
        return (CommandMap)server.getClass().getMethod("getCommandMap", new Class[0]).invoke((Object)server, new Object[0]);
    }

    private Map<String, Command> getKnownCommands(CommandMap commandMap) throws Exception {
        for (Class clazz = commandMap.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField("knownCommands");
                field.setAccessible(true);
                return (Map)field.get(commandMap);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("knownCommands not found in hierarchy");
    }

    public boolean canExecute(String module, String command) {
        Module mod = this.modules.get(module.toLowerCase());
        if (mod == null) {
            return true;
        }
        if (!mod.isEnabled()) {
            return false;
        }
        return mod.isCommandEnabled(command);
    }

    public Map<String, Module> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    private static class CommandRegistration {
        final String moduleName;
        final Command originalCommand;

        CommandRegistration(String moduleName, Command originalCommand) {
            this.moduleName = moduleName;
            this.originalCommand = originalCommand;
        }
    }
}

