/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.modules.Module;
import net.godlycow.org.modules.ModuleManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ModuleCommand
implements CommandExecutor,
TabCompleter {
    private final ModuleManager moduleManager;
    private final PlayerLanguageManager playerLanguageManager;
    private static final MiniMessage mini = MiniMessage.miniMessage();

    public ModuleCommand(ModuleManager moduleManager, PlayerLanguageManager playerLanguageManager) {
        this.moduleManager = moduleManager;
        this.playerLanguageManager = playerLanguageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("essc.command.module")) {
            sender.sendMessage(mini.deserialize("<red>\u2717 No permission."));
            return true;
        }
        this.sendModuleList(sender);
        return true;
    }

    private void sendModuleList(CommandSender sender) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(mini.deserialize("<yellow>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        messages.add(mini.deserialize("<gold><bold> MODULES & COMMANDS"));
        messages.add(Component.empty());
        for (Map.Entry<String, Module> entry : this.moduleManager.getModules().entrySet()) {
            String moduleName = entry.getKey();
            Module module = entry.getValue();
            String status = module.isEnabled() ? "<green>\u2713 ENABLED" : "<red>\u2717 DISABLED";
            messages.add(mini.deserialize("<yellow>\u25b8 <gold>" + moduleName + " <gray>- " + status));
            for (Map.Entry<String, Boolean> cmdEntry : module.getCommands().entrySet()) {
                String cmdName = cmdEntry.getKey();
                boolean enabled = cmdEntry.getValue();
                String cmdStatus = enabled ? "<green>\u2713" : "<red>\u2717";
                String cmdColor = enabled ? "" : "<strikethrough>";
                messages.add(mini.deserialize("  <dark_gray}> <white>" + cmdColor + "/" + cmdName + " <gray>" + cmdStatus));
            }
        }
        messages.add(Component.empty());
        messages.add(mini.deserialize("<yellow>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        messages.forEach(arg_0 -> sender.sendMessage(arg_0));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

