/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.managers.plugin;

import java.util.LinkedHashMap;
import java.util.Map;
import net.godlycow.org.EssC;
import net.godlycow.org.managers.plugin.Reloadable;
import org.bukkit.command.CommandSender;

public class ReloadManager {
    private static ReloadManager instance;
    private final EssC plugin;
    private final Map<String, Reloadable> reloadables = new LinkedHashMap<String, Reloadable>();

    public ReloadManager(EssC plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static ReloadManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ReloadManager has not been initialized yet!");
        }
        return instance;
    }

    public void register(Reloadable reloadable) {
        this.reloadables.put(reloadable.name().toLowerCase(), reloadable);
    }

    public static void reloadAll(CommandSender sender) {
        ReloadManager.getInstance().reloadEverything(sender);
    }

    public void reloadEverything(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7lReloading modules...");
        this.reloadables.values().forEach(reloadable -> {
            try {
                reloadable.reload();
                sender.sendMessage("\u00a7a\u2714 " + reloadable.name() + " reloaded!");
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7c\u2717 " + reloadable.name() + " failed to reload!");
                e.printStackTrace();
            }
        });
        sender.sendMessage("\u00a7a\u00a7lReload complete.");
    }
}

