/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.managers.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.database.DatabaseConfig;
import net.godlycow.org.database.DatabaseManager;
import net.godlycow.org.database.type.DatabaseType;
import org.bukkit.entity.Player;

public class SessionManager {
    private final Map<UUID, Long> currentSessions = new HashMap<UUID, Long>();
    private final Map<UUID, Long> longestSessions = new HashMap<UUID, Long>();
    private final DatabaseManager databaseManager;
    private final CommandDataStorage dataStorage;
    private final String poolKey = "session";
    private boolean initialized = false;

    public SessionManager(DatabaseManager databaseManager, CommandDataStorage dataStorage) {
        this.databaseManager = databaseManager;
        this.dataStorage = dataStorage;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        DatabaseConfig config = new DatabaseConfig(DatabaseType.SQLITE, "session.db", null, 0, null, null, null, 5);
        this.databaseManager.initializePool("session", config);
        this.initTable();
        this.initialized = true;
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS session_data (player_uuid TEXT PRIMARY KEY, longest_session_ms BIGINT NOT NULL DEFAULT 0, last_updated BIGINT NOT NULL)";
        this.databaseManager.executeUpdate("session", sql, new Object[0]).join();
    }

    public void startSession(Player player) {
        this.currentSessions.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void endSession(Player player) {
        UUID uuid = player.getUniqueId();
        Long startTime = this.currentSessions.get(uuid);
        if (startTime == null) {
            return;
        }
        long duration = System.currentTimeMillis() - startTime;
        this.currentSessions.remove(uuid);
        this.getLongestSession(player).thenAccept(previousLongest -> {
            if (duration > previousLongest) {
                this.longestSessions.put(uuid, duration);
                this.saveLongestSession(uuid, duration);
            }
        });
    }

    public long getCurrentSession(Player player) {
        Long startTime = this.currentSessions.get(player.getUniqueId());
        if (startTime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    public CompletableFuture<Long> getLongestSession(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.longestSessions.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.longestSessions.get(uuid));
        }
        return this.dataStorage.getState(uuid, "session", "longest").thenApply(opt -> {
            long longest = opt.map(Long::parseLong).orElse(0L);
            this.longestSessions.put(uuid, longest);
            return longest;
        });
    }

    private void saveLongestSession(UUID uuid, long duration) {
        this.dataStorage.setState(uuid, "session", "longest", String.valueOf(duration)).exceptionally(ex -> {
            System.err.println("Failed to save longest session for " + String.valueOf(uuid) + ": " + ex.getMessage());
            return null;
        });
    }
}

