/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.managers.player;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlaytimeManager {
    private final EssC plugin;
    private final File playtimeFile;
    private final FileConfiguration playtimeConfig;

    public PlaytimeManager(EssC plugin) {
        File storageFolder;
        this.plugin = plugin;
        File pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!(storageFolder = new File(pluginFolder, "storage")).exists()) {
            storageFolder.mkdirs();
        }
        this.playtimeFile = new File(storageFolder, "PlayTime.yml");
        if (!this.playtimeFile.exists()) {
            try {
                this.playtimeFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.playtimeConfig = YamlConfiguration.loadConfiguration((File)this.playtimeFile);
        this.loadOnlinePlayers();
    }

    public void savePlaytime(UUID uuid, long seconds) {
        this.playtimeConfig.set(uuid.toString(), (Object)seconds);
        this.saveFile();
    }

    public long getPlaytime(UUID uuid) {
        return this.playtimeConfig.getLong(uuid.toString(), 0L);
    }

    public void updatePlaytime(Player player) {
        long ticks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        long seconds = ticks / 20L;
        this.savePlaytime(player.getUniqueId(), seconds);
        Bukkit.getLogger().info("Saved playtime for " + player.getName() + ": " + seconds + "s");
    }

    public void updatePlaytime(OfflinePlayer player) {
        if (player.isOnline() && player.getPlayer() != null) {
            this.updatePlaytime(player.getPlayer());
        }
    }

    public List<Map.Entry<UUID, Long>> getTopPlaytimes(int top) {
        HashMap<UUID, Long> sorted = new HashMap<UUID, Long>();
        for (String key : this.playtimeConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                long time = this.playtimeConfig.getLong(key);
                sorted.put(uuid, time);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return sorted.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(top).collect(Collectors.toList());
    }

    private void saveFile() {
        try {
            this.playtimeConfig.save(this.playtimeFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadOnlinePlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlaytime(player);
        }
    }
}

