/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.mail.api;

import com.serveressentials.api.mail.MailAPI;
import com.serveressentials.api.mail.MailInfo;
import com.serveressentials.api.mail.MailStats;
import com.serveressentials.api.mail.event.MailClearEvent;
import com.serveressentials.api.mail.event.MailReadEvent;
import com.serveressentials.api.mail.event.MailSendEvent;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.mail.MailConfig;
import net.godlycow.org.mail.model.MailMessage;
import net.godlycow.org.mail.storage.MailStorage;
import net.godlycow.org.mail.trigger.MailListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class MailAPIImpl
implements MailAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final MailStorage mailStorage;
    @NotNull
    private final MailConfig mailConfig;
    @NotNull
    private final MailListener mailListener;

    public MailAPIImpl(@NotNull EssC plugin, @NotNull MailStorage mailStorage, @NotNull MailConfig mailConfig, @NotNull MailListener mailListener) {
        this.plugin = plugin;
        this.mailStorage = mailStorage;
        this.mailConfig = mailConfig;
        this.mailListener = mailListener;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendMail(@NotNull Player sender, @NotNull String targetName, @NotNull String message) {
        return CompletableFuture.supplyAsync(() -> {
            long remainingCooldown = this.getRemainingCooldown(sender.getUniqueId()).join();
            if (remainingCooldown > 0L) {
                return false;
            }
            if (message.length() > this.mailConfig.maxLength) {
                return false;
            }
            OfflinePlayer target = this.plugin.getServer().getOfflinePlayerIfCached(targetName);
            if ((target == null || target.getName() == null) && (target = this.plugin.getServer().getOfflinePlayer(targetName)).getName() == null) {
                return false;
            }
            String plainMessage = LegacyComponentSerializer.legacyAmpersand().serialize(Component.text(message));
            MailMessage mailMessage = MailMessage.create(sender.getUniqueId(), sender.getName(), plainMessage);
            this.mailStorage.addMail(target.getUniqueId(), mailMessage).join();
            this.mailStorage.saveCooldown(sender.getUniqueId(), System.currentTimeMillis()).join();
            MailInfo mailInfo = new MailInfo(sender.getUniqueId(), sender.getName(), message, System.currentTimeMillis(), target.getUniqueId(), false);
            OfflinePlayer finalTarget = target;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MailSendEvent(sender, mailInfo, finalTarget.getName(), finalTarget.getUniqueId())));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<MailInfo>> getMailbox(@NotNull Player player) {
        return ((CompletableFuture)this.mailStorage.getMailbox(player.getUniqueId()).thenApply(mails -> mails.stream().map(mail -> new MailInfo(mail.senderId(), mail.senderName(), mail.message(), mail.timestamp(), player.getUniqueId(), false)).collect(Collectors.toList()))).thenCompose(mailInfos -> {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MailReadEvent(player, (List<MailInfo>)mailInfos)));
            return CompletableFuture.completedFuture(mailInfos);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<MailInfo>> getUnreadMailbox(@NotNull Player player) {
        return this.mailStorage.getUnreadCount(player.getUniqueId()).thenCompose(unreadCount -> {
            if (unreadCount == 0) {
                return CompletableFuture.completedFuture(List.of());
            }
            return this.getMailbox(player).thenApply(mailInfos -> mailInfos.subList(0, Math.min(unreadCount, mailInfos.size())));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<MailStats> getMailStats(@NotNull UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            int totalCount = this.mailStorage.getTotalMailCount(playerId).join();
            int unreadCount = this.mailStorage.getUnreadCount(playerId).join();
            long lastActivity = this.mailStorage.getCooldown(playerId).join();
            return new MailStats(playerId, totalCount, unreadCount, lastActivity);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> markAllAsRead(@NotNull UUID playerId) {
        return this.mailStorage.markAllAsRead(playerId);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> clearMailbox(@NotNull UUID playerId) {
        return CompletableFuture.runAsync(() -> {
            int count = this.mailStorage.getTotalMailCount(playerId).join();
            this.mailStorage.clearMailbox(playerId).join();
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player != null && player.isOnline()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MailClearEvent(player, count)));
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Long> getRemainingCooldown(@NotNull UUID playerId) {
        return this.mailStorage.getCooldown(playerId).thenApply(lastUsed -> {
            if (lastUsed == 0L) {
                return 0L;
            }
            long now = System.currentTimeMillis();
            int cooldownMs = this.mailConfig.cooldown * 1000;
            long elapsed = now - lastUsed;
            long remaining = (long)cooldownMs - elapsed;
            return Math.max(0L, remaining / 1000L);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("mail.enabled", true);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.mailConfig.reload();
            this.plugin.getLogger().info("[ServerEssentials] Mail configuration reloaded");
        });
    }

    public void resetJoinNotification(@NotNull UUID playerId) {
        this.mailListener.resetNotification(playerId);
    }
}

