/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.lobby.trigger;

import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.LobbyConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.lobby.helper.AnimationHelper;
import net.godlycow.org.lobby.storage.LobbyStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class LobbyListener
implements Listener {
    private final PlayerLanguageManager langManager;
    private final LobbyStorage storage;
    private final LobbyConfig config;

    public LobbyListener(PlayerLanguageManager langManager, LobbyStorage storage, LobbyConfig config) {
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.isTeleportOnJoin()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("essc.command.lobby")) {
            return;
        }
        String worldKey = this.config.isPerWorld() ? player.getWorld().getName() : "global";
        ((CompletableFuture)this.storage.getLobby(worldKey).thenAccept(optLocation -> {
            if (optLocation.isPresent()) {
                Location lobby = (Location)optLocation.get();
                Bukkit.getScheduler().runTask(this.config.plugin, () -> {
                    if (this.config.isAnimationEnabled()) {
                        AnimationHelper.playTeleportAnimation(this.config.plugin, player, this.config.getAnimation());
                    }
                    player.teleport(lobby);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.lobby.teleported", "<green>Teleported to lobby!", new LanguageManager.ComponentPlaceholder[0]));
                });
            }
        })).exceptionally(ex -> {
            this.config.plugin.getLogger().severe("Failed to teleport player on join: " + ex.getMessage());
            return null;
        });
    }
}

