/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.lobby.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.database.DatabaseManager;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class LobbyStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "lobby";
    private final Plugin plugin;

    public LobbyStorage(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initTable();
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS lobby_locations (world TEXT PRIMARY KEY, location_data TEXT NOT NULL)";
        this.dbManager.executeUpdate("lobby", sql, new Object[0]);
    }

    public CompletableFuture<Void> setLobby(Location location) {
        return this.setWorldLobby("global", location);
    }

    public CompletableFuture<Void> setWorldLobby(String world, Location location) {
        String sql = "INSERT OR REPLACE INTO lobby_locations VALUES (?, ?)";
        String serialized = this.serializeLocation(location);
        return this.dbManager.executeUpdate("lobby", sql, world, serialized);
    }

    public CompletableFuture<Optional<Location>> getLobby(String world) {
        if (world == null) {
            return this.getGlobalLobby();
        }
        return this.getWorldLobby(world).thenCompose(opt -> {
            if (opt.isPresent()) {
                return CompletableFuture.completedFuture(opt);
            }
            return this.getGlobalLobby();
        });
    }

    private CompletableFuture<Optional<Location>> getGlobalLobby() {
        return this.getWorldLobby("global");
    }

    private CompletableFuture<Optional<Location>> getWorldLobby(String world) {
        String sql = "SELECT location_data FROM lobby_locations WHERE world = ?";
        return this.dbManager.executeQuery("lobby", sql, rs -> rs.next() ? this.deserializeLocation(rs.getString("location_data")) : null, world);
    }

    public CompletableFuture<Void> removeLobby(String world) {
        if (world == null) {
            return this.removeGlobalLobby();
        }
        String sql = "DELETE FROM lobby_locations WHERE world = ?";
        return this.dbManager.executeUpdate("lobby", sql, world);
    }

    private CompletableFuture<Void> removeGlobalLobby() {
        String sql = "DELETE FROM lobby_locations WHERE world = ?";
        return this.dbManager.executeUpdate("lobby", sql, "global");
    }

    public CompletableFuture<Boolean> hasLobby(String world) {
        return this.getLobby(world).thenApply(Optional::isPresent);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String serializeLocation(Location loc) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream boos = new BukkitObjectOutputStream((OutputStream)baos);){
                boos.writeObject((Object)loc);
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to serialize location: " + e.getMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Location deserializeLocation(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            Location location;
            try (BukkitObjectInputStream bois = new BukkitObjectInputStream((InputStream)bais);){
                location = (Location)bois.readObject();
            }
            return location;
        }
        catch (IOException | ClassNotFoundException e) {
            this.plugin.getLogger().severe("Failed to deserialize location: " + e.getMessage());
            return null;
        }
    }
}

