/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.lobby.api;

import com.serveressentials.api.lobby.LobbyAPI;
import com.serveressentials.api.lobby.LobbyLocation;
import com.serveressentials.api.lobby.event.LobbySetEvent;
import com.serveressentials.api.lobby.event.LobbyTeleportEvent;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.LobbyConfig;
import net.godlycow.org.lobby.helper.AnimationHelper;
import net.godlycow.org.lobby.storage.LobbyStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LobbyAPIImpl
implements LobbyAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final LobbyStorage lobbyStorage;
    @NotNull
    private final LobbyConfig lobbyConfig;

    public LobbyAPIImpl(@NotNull EssC plugin, @NotNull LobbyStorage lobbyStorage, @NotNull LobbyConfig lobbyConfig) {
        this.plugin = plugin;
        this.lobbyStorage = lobbyStorage;
        this.lobbyConfig = lobbyConfig;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportToLobby(@NotNull Player player) {
        String worldKey = this.lobbyConfig.isPerWorld() ? player.getWorld().getName() : null;
        return this.teleportToLobby(player, worldKey);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportToLobby(@NotNull Player player, @Nullable String worldKey) {
        return CompletableFuture.supplyAsync(() -> {
            if (!player.hasPermission("essc.command.lobby")) {
                return false;
            }
            if (!this.lobbyStorage.hasLobby(worldKey).join().booleanValue()) {
                return false;
            }
            Optional<Location> locationOpt = this.lobbyStorage.getLobby(worldKey).join();
            if (!locationOpt.isPresent()) {
                return false;
            }
            Location bukkitLocation = locationOpt.get();
            LobbyLocation lobbyLocation = new LobbyLocation(bukkitLocation.getWorld().getName(), bukkitLocation.getX(), bukkitLocation.getY(), bukkitLocation.getZ(), bukkitLocation.getYaw(), bukkitLocation.getPitch());
            Location fromLocation = player.getLocation();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.getPluginManager().callEvent((Event)new LobbyTeleportEvent(player, lobbyLocation, fromLocation, worldKey, worldKey != null));
                if (this.lobbyConfig.isAnimationEnabled() && this.lobbyConfig.getAnimation() != null) {
                    AnimationHelper.playTeleportAnimation((Plugin)this.plugin, player, this.lobbyConfig.getAnimation());
                }
                player.teleport(bukkitLocation);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to lobby!");
            });
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setLobby(@NotNull Player player, @NotNull Location location) {
        return this.setLobby(player, location, null);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setLobby(@NotNull Player player, @NotNull Location location, @Nullable String worldKey) {
        return CompletableFuture.runAsync(() -> {
            if (worldKey == null && !player.hasPermission("essc.command.lobby.set")) {
                throw new SecurityException("No permission to set global lobby");
            }
            if (worldKey != null && !player.hasPermission("essc.command.lobby.world")) {
                throw new SecurityException("No permission to set world lobby");
            }
            LobbyLocation lobbyLocation = new LobbyLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            if (worldKey == null) {
                this.lobbyStorage.setLobby(location).join();
            } else {
                this.lobbyStorage.setWorldLobby(worldKey, location).join();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new LobbySetEvent(player, lobbyLocation, worldKey, worldKey != null)));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Void> removeLobby() {
        return this.removeLobby(null);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> removeLobby(@Nullable String worldKey) {
        return CompletableFuture.runAsync(() -> this.lobbyStorage.removeLobby(worldKey).join());
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<LobbyLocation>> getLobby(@Nullable String worldKey) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<Location> locationOpt = this.lobbyStorage.getLobby(worldKey).join();
            return locationOpt.map(location -> new LobbyLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> hasLobby(@Nullable String worldKey) {
        return this.lobbyStorage.hasLobby(worldKey);
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("lobby.enabled", true);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.lobbyConfig.reload();
            this.plugin.getLogger().info("[ServerEssentials] Lobby configuration reloaded");
        });
    }
}

