/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.language.storage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.godlycow.org.database.DatabaseManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public interface PlayerLanguageStorage {
    public CompletableFuture<Void> saveLanguage(UUID var1, String var2);

    public CompletableFuture<String> loadLanguage(UUID var1);

    public String getLanguageSync(UUID var1);

    public static class SqlStorage
    implements PlayerLanguageStorage {
        private final DatabaseManager dbManager;
        private final String poolKey;
        private final Map<UUID, String> cache = new HashMap<UUID, String>();

        public SqlStorage(DatabaseManager dbManager, String poolKey) {
            this.dbManager = dbManager;
            this.poolKey = poolKey;
            this.initTable();
        }

        private void initTable() {
            String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "CREATE TABLE IF NOT EXISTS player_languages (player_uuid VARCHAR(36) PRIMARY KEY, language_code VARCHAR(10), updated_at BIGINT)").orElse("CREATE TABLE IF NOT EXISTS player_languages (player_uuid TEXT PRIMARY KEY, language_code TEXT, updated_at INTEGER)");
            this.dbManager.executeUpdate(this.poolKey, sql, new Object[0]).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }

        @Override
        public CompletableFuture<Void> saveLanguage(UUID playerId, String languageCode) {
            this.cache.put(playerId, languageCode);
            String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "INSERT INTO player_languages (player_uuid, language_code, updated_at) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE language_code=VALUES(language_code), updated_at=VALUES(updated_at)").orElse("INSERT OR REPLACE INTO player_languages VALUES (?, ?, ?)");
            return this.dbManager.executeUpdate(this.poolKey, sql, playerId.toString(), languageCode, System.currentTimeMillis());
        }

        @Override
        public CompletableFuture<String> loadLanguage(UUID playerId) {
            return this.dbManager.executeQuery(this.poolKey, "SELECT language_code FROM player_languages WHERE player_uuid = ?", rs -> rs.next() ? rs.getString("language_code") : null, playerId.toString()).thenApply(opt -> opt.orElse("en"));
        }

        @Override
        public String getLanguageSync(UUID playerId) {
            return this.cache.getOrDefault(playerId, "en");
        }
    }

    public static class YamlStorage
    implements PlayerLanguageStorage {
        private final Plugin plugin;
        private final File file;
        private final Map<UUID, String> cache = new HashMap<UUID, String>();

        public YamlStorage(Plugin plugin) {
            this.plugin = plugin;
            this.file = new File(plugin.getDataFolder(), "player_languages.yml");
            this.loadCache();
        }

        private void loadCache() {
            if (!this.file.exists()) {
                return;
            }
            try {
                HashMap data = new HashMap();
                YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.file);
                for (String key : yaml.getKeys(false)) {
                    try {
                        UUID uuid = UUID.fromString(key);
                        String lang = yaml.getString(key);
                        if (lang == null) continue;
                        this.cache.put(uuid, lang);
                    }
                    catch (IllegalArgumentException ex) {
                        this.plugin.getLogger().warning("Invalid UUID in language file: " + key);
                    }
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load player languages from YAML", ex);
            }
        }

        @Override
        public CompletableFuture<Void> saveLanguage(UUID playerId, String languageCode) {
            return CompletableFuture.runAsync(() -> {
                this.cache.put(playerId, languageCode);
                YamlConfiguration yaml = new YamlConfiguration();
                this.cache.forEach((uuid, lang) -> yaml.set(uuid.toString(), lang));
                try {
                    yaml.save(this.file);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to save player language", e);
                }
            });
        }

        @Override
        public CompletableFuture<String> loadLanguage(UUID playerId) {
            return CompletableFuture.supplyAsync(() -> this.getLanguageSync(playerId));
        }

        @Override
        public String getLanguageSync(UUID playerId) {
            return this.cache.getOrDefault(playerId, "en");
        }
    }
}

