/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.language;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.storage.PlayerLanguageStorage;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class PlayerLanguageManager
extends LanguageManager {
    private final PlayerLanguageStorage storage;
    private final LanguageManager languageManager;
    private final ConcurrentHashMap<UUID, String> cache = new ConcurrentHashMap();

    public PlayerLanguageManager(PlayerLanguageStorage storage, LanguageManager languageManager) {
        this.storage = storage;
        this.languageManager = languageManager;
    }

    public void setPlayerLanguage(UUID playerId, String languageCode) {
        if (!this.languageManager.hasLanguage(languageCode)) {
            throw new IllegalArgumentException("Invalid language: " + languageCode);
        }
        this.cache.put(playerId, languageCode);
        this.storage.saveLanguage(playerId, languageCode);
    }

    public String getPlayerLanguage(UUID playerId) {
        return this.cache.computeIfAbsent(playerId, this.storage::getLanguageSync);
    }

    public Component getMessageFor(Player player, String key, String def, LanguageManager.ComponentPlaceholder ... placeholders) {
        String langId = player != null ? this.getPlayerLanguage(player.getUniqueId()) : this.languageManager.getDefaultLanguage();
        return this.languageManager.getComponent(langId, key, def, placeholders);
    }

    public List<Component> getMessageList(Player player, String key) {
        String langId = player != null ? this.getPlayerLanguage(player.getUniqueId()) : this.languageManager.getDefaultLanguage();
        return this.languageManager.getComponentList(langId, key);
    }

    public void loadPlayerLanguageAsync(UUID playerId) {
        this.storage.loadLanguage(playerId).thenAccept(lang -> {
            if (lang != null) {
                this.cache.put(playerId, (String)lang);
            }
        });
    }
}

