/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.kit.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.godlycow.org.commands.config.KitConfig;
import net.godlycow.org.kit.KitConfigManager;
import net.godlycow.org.kit.KitManager;
import net.godlycow.org.kit.gui.KitGUIManager;
import net.godlycow.org.kit.gui.KitInventoryHolder;
import net.godlycow.org.kit.model.Kit;
import net.godlycow.org.kit.permission.KitPermission;
import net.godlycow.org.kit.storage.KitStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final KitStorage kitStorage;
    private final KitConfig kitConfig;
    private final KitGUIManager kitGUIManager;
    private static final String GUI_TITLE_KEY = "kits.gui.title";
    private static final String PREVIEW_TITLE_KEY = "kits.gui.preview-title";
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();

    public KitGUIListener(Plugin plugin, PlayerLanguageManager langManager, KitStorage kitStorage, KitConfig kitConfig, KitGUIManager kitGUIManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.kitStorage = kitStorage;
        this.kitConfig = kitConfig;
        this.kitGUIManager = kitGUIManager;
    }

    public void openKitGUI(Player player) {
        this.kitStorage.loadIntoCache(player.getUniqueId());
        Component titleComponent = this.langManager.getMessageFor(player, GUI_TITLE_KEY, this.kitConfig.getGuiTitle(), new LanguageManager.ComponentPlaceholder[0]);
        String legacyTitle = LEGACY_SERIALIZER.serialize(titleComponent);
        KitInventoryHolder holder = new KitInventoryHolder(this.kitGUIManager, false);
        Inventory gui = Bukkit.createInventory((InventoryHolder)holder, (int)this.kitConfig.getGuiSize(), (String)legacyTitle);
        gui.clear();
        ConfigurationSection kitsSec = KitConfigManager.getConfig().getConfigurationSection("kits");
        if (kitsSec == null) {
            player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.no-kits-defined", "<red>No kits are currently defined!", new LanguageManager.ComponentPlaceholder[0])));
            return;
        }
        int slotIndex = 0;
        for (String kitId : kitsSec.getKeys(false)) {
            int slot;
            Kit kit = KitManager.getKit(kitId);
            if (kit == null) continue;
            boolean hasPermission = kit.getPermission() == null || kit.getPermission().isEmpty() || player.hasPermission(kit.getPermission());
            int n = slot = kit.getSlot() > 0 ? kit.getSlot() : slotIndex;
            if (slot >= gui.getSize()) {
                slot = slotIndex;
            }
            slotIndex = Math.max(slot + 1, slotIndex + 1);
            ItemStack icon = this.createKitIcon(kit, player, hasPermission);
            gui.setItem(slot, icon);
        }
        player.openInventory(gui);
        this.kitGUIManager.setPlayerInMainGUI(player.getUniqueId(), true);
    }

    private ItemStack createKitIcon(Kit kit, Player player, boolean hasPermission) {
        long remaining;
        ItemStack icon = new ItemStack(hasPermission ? kit.getDisplayMaterial() : Material.BARRIER);
        ItemMeta meta = icon.getItemMeta();
        if (meta == null) {
            return icon;
        }
        Object name = hasPermission ? this.miniMessage.deserialize(kit.getDisplayName()) : this.langManager.getMessageFor(player, "commands.kits.locked-name", "<red>Locked: <gray>{kit}", LanguageManager.ComponentPlaceholder.of("{kit}", kit.getName()));
        meta.setDisplayName(LEGACY_SERIALIZER.serialize((Component)name));
        ArrayList<Object> lore = new ArrayList<Object>();
        for (String line : kit.getDisplayLore()) {
            lore.add(this.miniMessage.deserialize(line));
        }
        if (!hasPermission) {
            lore.add(this.langManager.getMessageFor(player, "commands.kits.requires-permission", "<gray>Requires: <white>{permission}", LanguageManager.ComponentPlaceholder.of("{permission}", KitPermission.node(kit.getName()))));
        }
        if ((remaining = this.kitStorage.getRemainingCooldown(player.getUniqueId(), kit.getName(), KitConfigManager.getConfig().getInt("kits." + kit.getName() + ".cooldown", 0))) > 0L) {
            lore.add(this.langManager.getMessageFor(player, "commands.kits.cooldown-info", "<gray>Cooldown: <red>{time}s", LanguageManager.ComponentPlaceholder.of("{time}", remaining)));
        }
        meta.setLore(lore.stream().map(LEGACY_SERIALIZER::serialize).collect(Collectors.toList()));
        NamespacedKey key = new NamespacedKey(this.plugin, "kit_id");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)kit.getName());
        icon.setItemMeta(meta);
        return icon;
    }

    public void openKitPreview(Player player, String kitId) {
        Kit kit = KitManager.getKit(kitId);
        if (kit == null) {
            player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.kit-not-found", "<red>Kit <white>{kit}</white> not found!", LanguageManager.ComponentPlaceholder.of("{kit}", kitId))));
            return;
        }
        Component titleComponent = this.langManager.getMessageFor(player, PREVIEW_TITLE_KEY, this.kitConfig.getPreviewTitle(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId));
        String legacyTitle = LEGACY_SERIALIZER.serialize(titleComponent);
        KitInventoryHolder holder = new KitInventoryHolder(this.kitGUIManager, true);
        Inventory preview = Bukkit.createInventory((InventoryHolder)holder, (int)54, (String)legacyTitle);
        preview.clear();
        List<ItemStack> items = kit.getItems();
        for (int i = 0; i < items.size() && i < 45; ++i) {
            preview.setItem(i, items.get(i));
        }
        ItemStack claimButton = this.createClaimButton(player, kitId);
        preview.setItem(53, claimButton);
        ItemStack backButton = this.createBackButton(player);
        preview.setItem(45, backButton);
        player.openInventory(preview);
        this.kitGUIManager.setPlayerInPreviewGUI(player.getUniqueId(), true);
    }

    private ItemStack createClaimButton(Player player, String kitId) {
        ItemStack item = new ItemStack(this.kitConfig.getClaimButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        int cooldown = KitConfigManager.getConfig().getInt("kits." + kitId + ".cooldown", 0);
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kitId, cooldown)) {
            item.setType(this.kitConfig.getCooldownButtonMaterial());
            meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.cooldown-button", "<red>\u23f1 On Cooldown", new LanguageManager.ComponentPlaceholder[0])));
        } else {
            meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.claim-button", "<green>\u2713 Claim Kit", new LanguageManager.ComponentPlaceholder[0])));
        }
        NamespacedKey key = new NamespacedKey(this.plugin, "kit_action");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("claim:" + kitId));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createBackButton(Player player) {
        ItemStack item = new ItemStack(this.kitConfig.getBackButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.back-button", "<red>\u2190 Back", new LanguageManager.ComponentPlaceholder[0])));
            NamespacedKey key = new NamespacedKey(this.plugin, "kit_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"back");
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getView().getTopInventory().getHolder() instanceof KitInventoryHolder)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        NamespacedKey actionKey = new NamespacedKey(this.plugin, "kit_action");
        String action = (String)clicked.getItemMeta().getPersistentDataContainer().get(actionKey, PersistentDataType.STRING);
        if (action != null) {
            if (action.startsWith("claim:")) {
                String kitId = action.substring(6);
                this.claimKit(player, kitId);
                player.closeInventory();
            } else if (action.equals("back")) {
                this.openKitGUI(player);
            }
            return;
        }
        NamespacedKey kitKey = new NamespacedKey(this.plugin, "kit_id");
        String kitId = (String)clicked.getItemMeta().getPersistentDataContainer().get(kitKey, PersistentDataType.STRING);
        if (kitId != null) {
            this.openKitPreview(player, kitId);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.kitGUIManager.cleanupPlayer(player.getUniqueId());
    }

    private void claimKit(Player player, String kitId) {
        Kit kit = KitManager.getKit(kitId);
        if (kit == null) {
            player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.kit-not-found", "<red>Kit <white>{kit}</white> not found!", LanguageManager.ComponentPlaceholder.of("{kit}", kitId))));
            return;
        }
        if (!player.hasPermission(KitPermission.node(kitId))) {
            player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.no-permission", "<red>You don't have permission to claim <white>{kit}</white>!", LanguageManager.ComponentPlaceholder.of("{kit}", kitId), LanguageManager.ComponentPlaceholder.of("{permission}", KitPermission.node(kitId)))));
            return;
        }
        int cooldown = KitConfigManager.getConfig().getInt("kits." + kitId + ".cooldown", 0);
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kitId, cooldown)) {
            long remaining = this.kitStorage.getRemainingCooldown(player.getUniqueId(), kitId, cooldown);
            player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.cooldown", "<red>Please wait <yellow>{time}s</yellow> before claiming <white>{kit}</white> again!", LanguageManager.ComponentPlaceholder.of("{kit}", kitId), LanguageManager.ComponentPlaceholder.of("{time}", remaining))));
            return;
        }
        for (ItemStack item : kit.getItems()) {
            if (item == null) continue;
            player.getInventory().addItem(new ItemStack[]{item});
        }
        this.kitStorage.saveKitClaim(player.getUniqueId(), kitId);
        player.sendMessage(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.claim-success", "<green>\u2713 Successfully claimed kit <white>{kit}</white>!", LanguageManager.ComponentPlaceholder.of("{kit}", kitId))));
    }
}

