/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.kit.storage;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.database.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class KitStorage {
    private final Plugin plugin;
    private final DatabaseManager dbManager;
    private final String poolKey;
    private final ConcurrentHashMap<UUID, ConcurrentHashMap<String, KitClaimData>> cache = new ConcurrentHashMap();

    public KitStorage(Plugin plugin, DatabaseManager dbManager, String poolKey) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.poolKey = poolKey;
        this.initTable();
    }

    private void initTable() {
        String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "CREATE TABLE IF NOT EXISTS kit_claims (\n    player_uuid VARCHAR(36) NOT NULL,\n    kit_id VARCHAR(64) NOT NULL,\n    last_claimed BIGINT NOT NULL,\n    claim_count INTEGER DEFAULT 1,\n    PRIMARY KEY (player_uuid, kit_id)\n)\n").orElse("CREATE TABLE IF NOT EXISTS kit_claims (\n    player_uuid TEXT NOT NULL,\n    kit_id TEXT NOT NULL,\n    last_claimed INTEGER NOT NULL,\n    claim_count INTEGER DEFAULT 1,\n    PRIMARY KEY (player_uuid, kit_id)\n)\n");
        this.dbManager.executeUpdate(this.poolKey, sql, new Object[0]).exceptionally(ex -> {
            this.plugin.getLogger().severe("\u274c Failed to create kit_claims table: " + ex.getMessage());
            return null;
        });
    }

    public CompletableFuture<Void> saveKitClaim(UUID playerId, String kitId) {
        long now = System.currentTimeMillis();
        this.cache.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).put(kitId, new KitClaimData(now, this.getSync((UUID)playerId, (String)kitId).claimCount + 1));
        String sql = this.dbManager.getPoolKeys().stream().filter(key -> key.toLowerCase().contains("mysql")).findFirst().map(key -> "INSERT INTO kit_claims (player_uuid, kit_id, last_claimed, claim_count)\nVALUES (?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    last_claimed = VALUES(last_claimed),\n    claim_count = VALUES(claim_count)\n").orElse("INSERT OR REPLACE INTO kit_claims VALUES (?, ?, ?, ?)\n");
        return this.dbManager.executeUpdate(this.poolKey, sql, playerId.toString(), kitId.toLowerCase(), now, this.getSync((UUID)playerId, (String)kitId).claimCount);
    }

    public CompletableFuture<KitClaimData> getKitClaim(UUID playerId, String kitId) {
        return this.dbManager.executeQuery(this.poolKey, "SELECT last_claimed, claim_count FROM kit_claims WHERE player_uuid = ? AND kit_id = ?", rs -> rs.next() ? new KitClaimData(rs.getLong("last_claimed"), rs.getInt("claim_count")) : null, playerId.toString(), kitId.toLowerCase()).thenApply(opt -> opt.orElse(new KitClaimData(0L, 0)));
    }

    private KitClaimData getSync(UUID playerId, String kitId) {
        return this.cache.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).getOrDefault(kitId, new KitClaimData(0L, 0));
    }

    public boolean isOnCooldown(UUID playerId, String kitId, int cooldownSeconds) {
        KitClaimData data = this.getSync(playerId, kitId);
        if (data.lastClaimed() == 0L) {
            return false;
        }
        long elapsed = (System.currentTimeMillis() - data.lastClaimed()) / 1000L;
        return elapsed < (long)cooldownSeconds;
    }

    public long getRemainingCooldown(UUID playerId, String kitId, int cooldownSeconds) {
        KitClaimData data = this.getSync(playerId, kitId);
        if (data.lastClaimed() == 0L) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - data.lastClaimed()) / 1000L;
        long remaining = (long)cooldownSeconds - elapsed;
        return Math.max(0L, remaining);
    }

    public void loadIntoCache(UUID playerId) {
        this.dbManager.executeQuery(this.poolKey, "SELECT kit_id, last_claimed, claim_count FROM kit_claims WHERE player_uuid = ?", rs -> {
            while (rs.next()) {
                this.cache.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).put(rs.getString("kit_id").toLowerCase(), new KitClaimData(rs.getLong("last_claimed"), rs.getInt("claim_count")));
            }
            return null;
        }, playerId.toString());
    }

    public void unloadFromCache(UUID playerId) {
        this.cache.remove(playerId);
    }

    public record KitClaimData(long lastClaimed, int claimCount) {
    }
}

