/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.kit.gui;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class KitGUIManager {
    private final Set<UUID> playersInMainGUI = ConcurrentHashMap.newKeySet();
    private final Set<UUID> playersInPreviewGUI = ConcurrentHashMap.newKeySet();

    public void setPlayerInMainGUI(UUID playerId, boolean isOpen) {
        if (isOpen) {
            this.playersInMainGUI.add(playerId);
        } else {
            this.playersInMainGUI.remove(playerId);
        }
    }

    public void setPlayerInPreviewGUI(UUID playerId, boolean isOpen) {
        if (isOpen) {
            this.playersInPreviewGUI.add(playerId);
        } else {
            this.playersInPreviewGUI.remove(playerId);
        }
    }

    public boolean isPlayerInAnyKitGUI(UUID playerId) {
        return this.playersInMainGUI.contains(playerId) || this.playersInPreviewGUI.contains(playerId);
    }

    public void cleanupPlayer(UUID playerId) {
        this.playersInMainGUI.remove(playerId);
        this.playersInPreviewGUI.remove(playerId);
    }
}

