/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.kit.api;

import com.serveressentials.api.kit.KitAPI;
import com.serveressentials.api.kit.KitInfo;
import com.serveressentials.api.kit.KitItem;
import com.serveressentials.api.kit.event.KitClaimEvent;
import com.serveressentials.api.kit.event.KitOpenGUIEvent;
import com.serveressentials.api.kit.event.KitOpenPreviewEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.EssC;
import net.godlycow.org.commands.config.KitConfig;
import net.godlycow.org.kit.KitConfigManager;
import net.godlycow.org.kit.KitManager;
import net.godlycow.org.kit.model.Kit;
import net.godlycow.org.kit.permission.KitPermission;
import net.godlycow.org.kit.storage.KitStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class KitAPIImpl
implements KitAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final KitManager kitManager;
    @NotNull
    private final KitConfigManager kitConfigManager;
    @NotNull
    private final KitStorage kitStorage;
    @NotNull
    private final KitConfig kitConfig;
    @NotNull
    private final PlayerLanguageManager langManager;
    @NotNull
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();

    public KitAPIImpl(@NotNull EssC plugin, @NotNull KitManager kitManager, @NotNull KitConfigManager kitConfigManager, @NotNull KitStorage kitStorage, @NotNull KitConfig kitConfig, @NotNull PlayerLanguageManager langManager) {
        this.plugin = plugin;
        this.kitManager = kitManager;
        this.kitConfigManager = kitConfigManager;
        this.kitStorage = kitStorage;
        this.kitConfig = kitConfig;
        this.langManager = langManager;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> claimKit(@NotNull Player player, @NotNull String kitId) {
        return CompletableFuture.supplyAsync(() -> {
            String normalizedKitId = kitId.toLowerCase();
            Kit kit = KitManager.getKit(normalizedKitId);
            if (kit == null) {
                return false;
            }
            String permission = KitPermission.node(normalizedKitId);
            if (!player.hasPermission(permission)) {
                return false;
            }
            int cooldownSeconds = kit.getCooldown();
            if (this.kitStorage.isOnCooldown(player.getUniqueId(), normalizedKitId, cooldownSeconds)) {
                return false;
            }
            for (ItemStack item : kit.getItems()) {
                if (item == null) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
            this.kitStorage.saveKitClaim(player.getUniqueId(), normalizedKitId);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new KitClaimEvent(player, normalizedKitId, kit.getDisplayName())));
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> openKitGUI(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            this.kitStorage.loadIntoCache(player.getUniqueId());
            KitAPIImpl kitAPIImpl = this;
            List kits = kitAPIImpl.kitManager.getKits().values().stream().filter(kit -> {
                String perm = KitPermission.node(kit.getName());
                return kit.getPermission() == null || kit.getPermission().isEmpty() || player.hasPermission(perm);
            }).collect(Collectors.toList());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Component titleComponent = this.langManager.getMessageFor(player, "commands.kits.gui.title", this.kitConfig.getGuiTitle(), new LanguageManager.ComponentPlaceholder[0]);
                String legacyTitle = LEGACY_SERIALIZER.serialize(titleComponent);
                Inventory gui = Bukkit.createInventory(null, (int)this.kitConfig.getGuiSize(), (String)legacyTitle);
                int slotIndex = 0;
                for (Kit kit : kits) {
                    int slot;
                    int n = slot = kit.getSlot() > 0 ? kit.getSlot() : slotIndex;
                    if (slot >= gui.getSize()) {
                        slot = slotIndex;
                    }
                    slotIndex = Math.max(slot + 1, slotIndex + 1);
                    ItemStack icon = this.createKitIcon(kit, player);
                    gui.setItem(slot, icon);
                }
                player.openInventory(gui);
                Bukkit.getPluginManager().callEvent((Event)new KitOpenGUIEvent(player, kits.size()));
            });
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> openKitPreview(@NotNull Player player, @NotNull String kitId) {
        return CompletableFuture.supplyAsync(() -> {
            String normalizedKitId = kitId.toLowerCase();
            Kit kit = KitManager.getKit(normalizedKitId);
            if (kit == null) {
                return false;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Component titleComponent = this.langManager.getMessageFor(player, "commands.kits.gui.preview-title", this.kitConfig.getPreviewTitle(), LanguageManager.ComponentPlaceholder.of("{kit}", kitId));
                String legacyTitle = LEGACY_SERIALIZER.serialize(titleComponent);
                Inventory preview = Bukkit.createInventory(null, (int)54, (String)legacyTitle);
                List<ItemStack> items = kit.getItems();
                for (int i = 0; i < items.size() && i < 45; ++i) {
                    preview.setItem(i, items.get(i));
                }
                preview.setItem(53, this.createClaimButton(player, normalizedKitId));
                preview.setItem(45, this.createBackButton(player));
                player.openInventory(preview);
                Bukkit.getPluginManager().callEvent((Event)new KitOpenPreviewEvent(player, normalizedKitId, kit.getDisplayName()));
            });
            return true;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<KitInfo>> getAvailableKits(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            KitAPIImpl kitAPIImpl = this;
            return kitAPIImpl.kitManager.getKits().values().stream().map(this::convertToKitInfo).collect(Collectors.toList());
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Long> getRemainingCooldown(@NotNull Player player, @NotNull String kitId) {
        return CompletableFuture.supplyAsync(() -> {
            String normalizedKitId = kitId.toLowerCase();
            Kit kit = KitManager.getKit(normalizedKitId);
            if (kit == null) {
                return 0L;
            }
            int cooldownSeconds = kit.getCooldown();
            return this.kitStorage.getRemainingCooldown(player.getUniqueId(), normalizedKitId, cooldownSeconds);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("kits.enabled", true);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.plugin.reloadConfig();
            this.kitConfig.load();
            KitAPIImpl kitAPIImpl = this;
            kitAPIImpl.kitConfigManager.reload();
            KitAPIImpl kitAPIImpl2 = this;
            this.plugin.getLogger().info("[ServerEssentials] Kit configuration reloaded: " + kitAPIImpl2.kitManager.getKits().size() + " kits loaded.");
        });
    }

    @NotNull
    private ItemStack createKitIcon(@NotNull Kit kit, @NotNull Player player) {
        String permission = KitPermission.node(kit.getName());
        boolean hasPermission = kit.getPermission() == null || kit.getPermission().isEmpty() || player.hasPermission(permission);
        Material material = hasPermission ? kit.getDisplayMaterial() : Material.BARRIER;
        ItemStack icon = new ItemStack(material);
        ItemMeta meta = icon.getItemMeta();
        if (meta == null) {
            return icon;
        }
        Object name = hasPermission ? this.miniMessage.deserialize(kit.getDisplayName()) : this.langManager.getMessageFor(player, "commands.kits.locked-name", "<red>Locked: <gray>{kit}", LanguageManager.ComponentPlaceholder.of("{kit}", kit.getName()));
        meta.setDisplayName(LEGACY_SERIALIZER.serialize((Component)name));
        ArrayList<Object> lore = new ArrayList<Object>();
        for (String line : kit.getDisplayLore()) {
            lore.add(this.miniMessage.deserialize(line));
        }
        if (!hasPermission) {
            lore.add(this.langManager.getMessageFor(player, "commands.kits.requires-permission", "<gray>Requires: <white>{permission}", LanguageManager.ComponentPlaceholder.of("{permission}", permission)));
        }
        int cooldown = kit.getCooldown();
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kit.getName(), cooldown)) {
            long remaining = this.kitStorage.getRemainingCooldown(player.getUniqueId(), kit.getName(), cooldown);
            lore.add(this.langManager.getMessageFor(player, "commands.kits.cooldown-info", "<gray>Cooldown: <red>{time}s", LanguageManager.ComponentPlaceholder.of("{time}", remaining)));
        }
        meta.setLore(lore.stream().map(LEGACY_SERIALIZER::serialize).collect(Collectors.toList()));
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "kit_id");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)kit.getName());
        icon.setItemMeta(meta);
        return icon;
    }

    @NotNull
    private ItemStack createClaimButton(@NotNull Player player, @NotNull String kitId) {
        ItemMeta meta;
        ItemStack item;
        int cooldown;
        Kit kit = KitManager.getKit(kitId);
        int n = cooldown = kit != null ? kit.getCooldown() : 0;
        if (this.kitStorage.isOnCooldown(player.getUniqueId(), kitId, cooldown)) {
            item = new ItemStack(this.kitConfig.getCooldownButtonMaterial());
            meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.cooldown-button", "<red>\u23f1 On Cooldown", new LanguageManager.ComponentPlaceholder[0])));
            }
        } else {
            item = new ItemStack(this.kitConfig.getClaimButtonMaterial());
            meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.claim-button", "<green>\u2713 Claim Kit", new LanguageManager.ComponentPlaceholder[0])));
            }
        }
        if (meta != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "kit_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("claim:" + kitId));
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    private ItemStack createBackButton(@NotNull Player player) {
        ItemStack item = new ItemStack(this.kitConfig.getBackButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(LEGACY_SERIALIZER.serialize(this.langManager.getMessageFor(player, "commands.kits.back-button", "<red>\u2190 Back", new LanguageManager.ComponentPlaceholder[0])));
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "kit_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)"back");
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    private KitInfo convertToKitInfo(@NotNull Kit kit) {
        return new KitInfo(kit.getName(), kit.getDisplayName(), kit.getPermission(), kit.getDisplayName(), kit.getDisplayMaterial().name(), kit.getDisplayLore(), kit.getSlot(), kit.getCooldown(), kit.getItems().stream().map(this::convertToKitItem).collect(Collectors.toList()));
    }

    @NotNull
    private KitItem convertToKitItem(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        return new KitItem(itemStack.getType().name(), itemStack.getAmount(), meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null, meta != null && meta.hasLore() ? meta.getLore() : null, null);
    }
}

