/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.godlycow.org.kit.model.Kit;
import net.godlycow.org.kit.permission.KitPermission;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitManager {
    private static final Map<String, Kit> kits = new LinkedHashMap<String, Kit>();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();

    public static void loadKits(FileConfiguration config) {
        kits.clear();
        kits.keySet().forEach(KitPermission::unregister);
        ConfigurationSection section = config.getConfigurationSection("kits");
        if (section == null) {
            return;
        }
        for (String rawKitName : section.getKeys(false)) {
            String kitName = rawKitName.toLowerCase();
            ConfigurationSection kitSection = section.getConfigurationSection(rawKitName);
            if (kitSection == null) continue;
            try {
                String displayName = kitSection.getString("display.name", rawKitName);
                String materialName = kitSection.getString("display.material", "SHULKER_BOX");
                Material material = Material.matchMaterial((String)materialName.toUpperCase());
                if (material == null) {
                    material = Material.SHULKER_BOX;
                }
                List lore = kitSection.getStringList("display.lore");
                int slot = kitSection.getInt("display.slot", -1);
                int cooldown = kitSection.getInt("cooldown", 0);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ConfigurationSection itemsSec = kitSection.getConfigurationSection("items");
                if (itemsSec != null) {
                    for (String key : itemsSec.getKeys(false)) {
                        ItemStack item = KitManager.parseItemFromConfig(itemsSec.getConfigurationSection(key));
                        if (item == null) continue;
                        items.add(item);
                    }
                }
                Kit kit = new Kit(kitName, "", displayName, material, lore, slot, items, cooldown);
                kits.put(kitName, kit);
                KitPermission.register(kitName);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to load kit '" + rawKitName + "'", e);
            }
        }
        Bukkit.getLogger().info("Loaded " + kits.size() + " kits.");
    }

    public static Map<String, Kit> getKits() {
        return Collections.unmodifiableMap(kits);
    }

    public static Kit getKit(String name) {
        return name != null ? kits.get(name.toLowerCase()) : null;
    }

    private static ItemStack parseItemFromConfig(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        try {
            Material material = Material.matchMaterial((String)section.getString("type", "STONE").toUpperCase());
            if (material == null) {
                return null;
            }
            int amount = section.getInt("amount", 1);
            ItemStack item = new ItemStack(material, amount);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                ConfigurationSection enchants;
                List lore;
                String displayName = section.getString("name");
                if (displayName != null) {
                    Object nameComponent = MINI_MESSAGE.deserialize(displayName);
                    meta.setDisplayName(LEGACY_SERIALIZER.serialize((Component)nameComponent));
                }
                if (!(lore = section.getStringList("lore")).isEmpty()) {
                    List legacyLore = lore.stream().map(line -> LEGACY_SERIALIZER.serialize((Component)MINI_MESSAGE.deserialize(line))).collect(Collectors.toList());
                    meta.setLore(legacyLore);
                }
                if ((enchants = section.getConfigurationSection("enchantments")) != null) {
                    for (String enchantName : enchants.getKeys(false)) {
                        Enchantment enchant = Enchantment.getByName((String)enchantName.toUpperCase());
                        int level = enchants.getInt(enchantName, 1);
                        if (enchant == null) continue;
                        meta.addEnchant(enchant, level, true);
                    }
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Error parsing kit item: " + e.getMessage());
            return null;
        }
    }
}

