/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.hooks;

import net.godlycow.org.hooks.LuckPermsHook;
import net.godlycow.org.hooks.PlaceholderAPIHook;
import net.godlycow.org.hooks.VaultHook;
import net.godlycow.org.util.logger.AnsiColorUtil;
import org.bukkit.plugin.java.JavaPlugin;

public class HooksManager {
    private static HooksManager instance;
    private final JavaPlugin plugin;
    private boolean vaultActive = false;
    private boolean luckPermsActive = false;
    private boolean papiActive = false;

    private HooksManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static HooksManager getInstance(JavaPlugin plugin) {
        if (instance == null) {
            instance = new HooksManager(plugin);
        }
        return instance;
    }

    public void initializeHooks() {
        this.plugin.getLogger().info("Initializing soft-dependencies...");
        try {
            this.vaultActive = VaultHook.getInstance().init();
            if (this.vaultActive) {
                this.plugin.getLogger().info(AnsiColorUtil.success("Vault hooked successfully!"));
            } else {
                this.plugin.getLogger().warning(AnsiColorUtil.warning("Vault not found, related features disabled."));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(AnsiColorUtil.warning("Failed to hook Vault: " + e.getMessage()));
            this.vaultActive = false;
        }
        try {
            this.luckPermsActive = LuckPermsHook.getInstance().init();
            if (this.luckPermsActive) {
                this.plugin.getLogger().info(AnsiColorUtil.success("LuckPerms hooked successfully!"));
            } else {
                this.plugin.getLogger().warning(AnsiColorUtil.warning("LuckPerms not found, related features disabled."));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(AnsiColorUtil.warning("Failed to hook LuckPerms: " + e.getMessage()));
            this.luckPermsActive = false;
        }
        try {
            this.papiActive = PlaceholderAPIHook.getInstance().init();
            if (this.papiActive) {
                this.plugin.getLogger().info(AnsiColorUtil.success("PlaceholderAPI hooked successfully!"));
            } else {
                this.plugin.getLogger().warning(AnsiColorUtil.warning("PlaceholderAPI not found, placeholders won't work."));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(AnsiColorUtil.warning("Failed to hook PlaceholderAPI: " + e.getMessage()));
            this.papiActive = false;
        }
    }

    public void cleanupHooks() {
        VaultHook.getInstance().cleanup();
        LuckPermsHook.getInstance().cleanup();
        PlaceholderAPIHook.getInstance().cleanup();
    }

    public VaultHook getVault() {
        return this.vaultActive ? VaultHook.getInstance() : null;
    }

    public LuckPermsHook getLuckPerms() {
        return this.luckPermsActive ? LuckPermsHook.getInstance() : null;
    }

    public PlaceholderAPIHook getPlaceholderAPI() {
        return this.papiActive ? PlaceholderAPIHook.getInstance() : null;
    }

    public boolean isVaultActive() {
        return this.vaultActive;
    }

    public boolean isLuckPermsActive() {
        return this.luckPermsActive;
    }

    public boolean isPlaceholderAPIActive() {
        return this.papiActive;
    }

    public boolean hasAnyHook() {
        return this.vaultActive || this.luckPermsActive || this.papiActive;
    }
}

