/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.hooks;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EconomyShopGUIHook {
    private static EconomyShopGUIHook instance;
    private Plugin economyShopGUI;
    private Method openShopMethod;
    private boolean available = false;

    private EconomyShopGUIHook() {
    }

    public static EconomyShopGUIHook getInstance() {
        if (instance == null) {
            instance = new EconomyShopGUIHook();
        }
        return instance;
    }

    public boolean init() {
        block5: {
            if (Bukkit.getPluginManager().getPlugin("EconomyShopGUI") == null) {
                this.available = false;
                return false;
            }
            try {
                this.economyShopGUI = Bukkit.getPluginManager().getPlugin("EconomyShopGUI");
                if (this.economyShopGUI == null) break block5;
                try {
                    Class pluginClass = this.economyShopGUI.getClass();
                    Method getShopManager = pluginClass.getMethod("getShopManager", new Class[0]);
                    Object shopManager = getShopManager.invoke((Object)this.economyShopGUI, new Object[0]);
                    this.openShopMethod = shopManager.getClass().getMethod("openShop", Player.class);
                    this.openShopMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    this.openShopMethod = null;
                }
                this.available = true;
                Bukkit.getLogger().info("[EssC] EconomyShopGUI hook initialized successfully.");
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.WARNING, "[EssC] Failed to initialize EconomyShopGUIHook", e);
                this.available = false;
            }
        }
        return this.available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void openMainGUI(Player player) {
        if (!this.available || this.economyShopGUI == null) {
            player.sendMessage("\u00a7cShop system is not available.");
            return;
        }
        Bukkit.getScheduler().runTask(this.economyShopGUI, () -> {
            try {
                if (this.openShopMethod != null) {
                    Method getShopManager = this.economyShopGUI.getClass().getMethod("getShopManager", new Class[0]);
                    Object shopManager = getShopManager.invoke((Object)this.economyShopGUI, new Object[0]);
                    this.openShopMethod.invoke(shopManager, player);
                } else {
                    player.performCommand("shop");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[EssC] Failed to open EconomyShopGUI, using command fallback: " + e.getMessage());
                player.performCommand("shop");
            }
        });
    }

    public void cleanup() {
        this.available = false;
        this.economyShopGUI = null;
        this.openShopMethod = null;
        instance = null;
    }
}

