/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.homes.gui.trigger;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.HomesConfig;
import net.godlycow.org.homes.HomeManager;
import net.godlycow.org.homes.gui.HomesConfirmHolder;
import net.godlycow.org.homes.gui.HomesMainHolder;
import net.godlycow.org.homes.model.Home;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HomeGUIListener
implements Listener {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final HomesConfig config;
    private final HomeManager homeManager;
    private final Map<Player, PendingAction> pendingActions = new WeakHashMap<Player, PendingAction>();
    private final Map<Player, Integer> awaitingRename = new WeakHashMap<Player, Integer>();
    private final Set<Inventory> trackedInventories = new HashSet<Inventory>();
    private final NamespacedKey displayKey;
    private static final Integer[] BED_SLOTS = new Integer[]{10, 12, 14, 16, 28, 30, 32, 34};
    private static final Integer[] DYE_SLOTS = new Integer[]{19, 21, 23, 25, 37, 39, 41, 43};

    public HomeGUIListener(Plugin plugin, PlayerLanguageManager langManager, HomesConfig config, HomeManager homeManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.homeManager = homeManager;
        this.displayKey = new NamespacedKey(plugin, "homes_display_item");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.trackedInventories.contains(event.getInventory())) {
            ItemStack current = event.getCurrentItem();
            if (current != null && this.isDisplayItem(current)) {
                event.setCancelled(true);
                return;
            }
            if (this.isBorderSlot(event.getRawSlot(), event.getInventory().getSize())) {
                event.setCancelled(true);
                return;
            }
        }
        if (event.getInventory().getHolder() instanceof HomesMainHolder) {
            event.setCancelled(true);
            this.handleMainGUIClick(player, event.getRawSlot(), event.getClick());
        } else if (event.getInventory().getHolder() instanceof HomesConfirmHolder) {
            event.setCancelled(true);
            this.handleConfirmGUIClick(player, event.getRawSlot());
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.trackedInventories.contains(event.getInventory())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (!this.isBorderSlot(slot, event.getInventory().getSize())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.trackedInventories.remove(event.getInventory());
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        Integer slot = this.awaitingRename.get(player);
        if (slot == null) {
            return;
        }
        event.setCancelled(true);
        this.awaitingRename.remove(player);
        String newName = event.getMessage().trim();
        if (newName.length() > this.config.maxHomeNameLength) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.too-long", "<red>\u274c Name too long! Maximum {max} characters.", LanguageManager.ComponentPlaceholder.of("{max}", this.config.maxHomeNameLength)));
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
            return;
        }
        this.homeManager.getAllHomes(player.getUniqueId()).thenAccept(homes -> {
            boolean duplicate;
            if (!this.config.allowDuplicateHomeNames && (duplicate = homes.entrySet().stream().anyMatch(entry -> entry.getValue() != null && ((Home)entry.getValue()).getName().equalsIgnoreCase(newName) && entry.getKey() != slot))) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.duplicate", "<red>\u274c You already have a home named '{name}'!", LanguageManager.ComponentPlaceholder.of("{name}", newName)));
                Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                return;
            }
            this.proceedWithRename(player, slot, newName);
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.pendingActions.remove(player);
        this.awaitingRename.remove(player);
    }

    private void handleMainGUIClick(Player player, int slot, ClickType clickType) {
        int i;
        if (this.config.isWorldDisabled(player.getWorld().getName())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.world-disabled", "<red>\u274c You cannot manage homes in this world!", new LanguageManager.ComponentPlaceholder[0]));
            player.closeInventory();
            return;
        }
        for (i = 0; i < BED_SLOTS.length; ++i) {
            if (slot != BED_SLOTS[i]) continue;
            this.handleBedClick(player, i + 1, clickType);
            return;
        }
        for (i = 0; i < DYE_SLOTS.length; ++i) {
            if (slot != DYE_SLOTS[i]) continue;
            this.handleDyeClick(player, i + 1);
            return;
        }
    }

    private void handleConfirmGUIClick(Player player, int rawSlot) {
        PendingAction action = this.pendingActions.get(player);
        if (action == null) {
            player.closeInventory();
            return;
        }
        if (rawSlot == 10) {
            this.confirmAction(player, action);
        } else if (rawSlot == 16) {
            this.pendingActions.remove(player);
            this.openMainGUI(player);
        }
    }

    private void proceedWithRename(Player player, int slot, String newName) {
        this.homeManager.getHome(player.getUniqueId(), slot).thenAccept(opt -> {
            if (opt.isPresent()) {
                Home home = (Home)opt.get();
                home.setName(newName);
                this.homeManager.setHome(player.getUniqueId(), slot, home).thenAccept(v -> {
                    if (v.booleanValue()) {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.success", "<green>\u2714 Home renamed to <yellow>{name}</yellow>!", LanguageManager.ComponentPlaceholder.of("{name}", newName)));
                    }
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                });
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.empty-slot", "<gray>No home set in slot {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
                Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
            }
        });
    }

    private void handleBedClick(Player player, int slot, ClickType clickType) {
        UUID uuid = player.getUniqueId();
        if (!this.canSetHome(player, slot)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.no-permission", "<red>\u274c You don't have permission to manage home {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
            return;
        }
        if (clickType.isLeftClick()) {
            this.homeManager.getHome(uuid, slot).thenAccept(opt -> {
                if (opt.isEmpty()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.empty-slot", "<gray>No home set in slot {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
                    return;
                }
                Location homeLoc = ((Home)opt.get()).toLocation();
                if (homeLoc == null) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.world-missing", "<red>\u274c Home world is no longer available!", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                if (!this.homeManager.canTeleport(uuid)) {
                    long remaining = this.homeManager.getRemainingTeleportCooldown(uuid);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.teleport-cooldown", "<red>\u23f1 Please wait {seconds} seconds before teleporting again!", LanguageManager.ComponentPlaceholder.of("{seconds}", remaining)));
                    return;
                }
                if (!this.config.allowCrossWorldTeleport && !player.getWorld().equals((Object)homeLoc.getWorld())) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.cross-world-disabled", "<red>\u274c Cross-world teleportation is disabled!", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                if (this.config.isTeleportRestricted(player.getWorld().getName())) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.teleport-restricted", "<red>\u274c You cannot teleport from this world!", new LanguageManager.ComponentPlaceholder[0]));
                    return;
                }
                this.homeManager.updateLastTeleportTime(uuid);
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    player.teleport(homeLoc);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.teleport", "<green>\u2714 Teleported to home <yellow>{slot}</yellow>!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
                });
            });
        } else {
            this.homeManager.getHome(uuid, slot).thenAccept(opt -> {
                boolean hasHome = opt.isPresent();
                if (!hasHome) {
                    if (!this.homeManager.canSetHome(uuid)) {
                        long remaining = this.homeManager.getRemainingSetCooldown(uuid);
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.set-cooldown", "<red>\u23f1 Please wait {seconds} seconds before setting another home!", LanguageManager.ComponentPlaceholder.of("{seconds}", remaining)));
                        return;
                    }
                    this.pendingActions.put(player, new PendingAction(Action.SET, slot));
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openConfirmGUI(player, slot, "set"));
                } else if (this.config.allowRename && player.hasPermission("essc.command.renamehome")) {
                    this.awaitingRename.put(player, slot);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.rename.prompt", "<yellow>Enter a new name for this home in chat:", new LanguageManager.ComponentPlaceholder[0]));
                    player.closeInventory();
                }
            });
        }
    }

    private void handleDyeClick(Player player, int slot) {
        this.plugin.getLogger().fine("Dye clicked by " + player.getName() + " for home slot " + slot);
        if (!player.hasPermission("essc.command.removehome")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.no-permission-remove", "<red>\u274c You don't have permission to remove homes!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        this.homeManager.getHome(player.getUniqueId(), slot).thenAccept(opt -> {
            if (opt.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.empty-slot", "<gray>No home set in slot {slot}!", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
                return;
            }
            this.pendingActions.put(player, new PendingAction(Action.REMOVE, slot));
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openConfirmGUI(player, slot, "remove"));
        });
    }

    private void confirmAction(Player player, PendingAction action) {
        UUID uuid = player.getUniqueId();
        if (this.config.isWorldDisabled(player.getWorld().getName())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.world-disabled", "<red>\u274c You cannot perform this action in this world!", new LanguageManager.ComponentPlaceholder[0]));
            this.pendingActions.remove(player);
            this.openMainGUI(player);
            return;
        }
        switch (action.action.ordinal()) {
            case 0: {
                if (!this.homeManager.canSetHome(uuid)) {
                    long remaining = this.homeManager.getRemainingSetCooldown(uuid);
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.set-cooldown", "<red>\u23f1 Please wait {seconds} seconds before setting another home!", LanguageManager.ComponentPlaceholder.of("{seconds}", remaining)));
                    this.pendingActions.remove(player);
                    this.openMainGUI(player);
                    return;
                }
                if (this.config.requireEmptyInventoryToSet && !player.getInventory().isEmpty()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.require-empty-inventory", "<red>\u274c You must have an empty inventory to set a home!", new LanguageManager.ComponentPlaceholder[0]));
                    this.pendingActions.remove(player);
                    this.openMainGUI(player);
                    return;
                }
                Home home = new Home("Home " + action.slot, player.getLocation());
                this.homeManager.setHome(uuid, action.slot, home).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.set", "<green>\u2714 Home <yellow>{slot}</yellow> set!", LanguageManager.ComponentPlaceholder.of("{slot}", action.slot)));
                    }
                    this.pendingActions.remove(player);
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                });
                return;
            }
            case 1: {
                this.homeManager.removeHome(uuid, action.slot).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.remove", "<green>\u2714 Home <yellow>{slot}</yellow> removed!", LanguageManager.ComponentPlaceholder.of("{slot}", action.slot)));
                    }
                    this.pendingActions.remove(player);
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                });
                return;
            }
            case 2: {
                this.pendingActions.remove(player);
                return;
            }
        }
    }

    public void openMainGUI(Player player) {
        if (this.config.isWorldDisabled(player.getWorld().getName())) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.homes.world-disabled", "<red>\u274c You cannot access homes in this world!", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Component title = this.langManager.getMessageFor(null, "commands.homes.gui.title", "<green>Home Manager", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new HomesMainHolder(), (int)54, (Component)title);
        this.trackedInventories.add(inv);
        this.fillBackground(inv);
        this.setupHomeSlots(player, inv).thenAccept(v -> Bukkit.getScheduler().runTask(this.plugin, () -> player.openInventory(inv)));
    }

    public void openConfirmGUI(Player player, int slot, String mode) {
        Component title = this.langManager.getMessageFor(null, "commands.homes.gui.confirm-title", "<red>Confirm Action", new LanguageManager.ComponentPlaceholder[0]);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new HomesConfirmHolder(slot, mode), (int)27, (Component)title);
        this.trackedInventories.add(inv);
        ItemStack confirm = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta confirmMeta = confirm.getItemMeta();
        confirmMeta.displayName(this.langManager.getMessageFor(player, "commands.homes.gui.confirm", "<green>\u2714 Confirm", new LanguageManager.ComponentPlaceholder[0]));
        confirm.setItemMeta(confirmMeta);
        inv.setItem(10, confirm);
        ItemStack cancel = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta cancelMeta = cancel.getItemMeta();
        cancelMeta.displayName(this.langManager.getMessageFor(player, "commands.homes.gui.cancel", "<red>\u274c Cancel", new LanguageManager.ComponentPlaceholder[0]));
        cancel.setItemMeta(cancelMeta);
        inv.setItem(16, cancel);
        ItemStack info = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = info.getItemMeta();
        infoMeta.displayName(this.langManager.getMessageFor(player, "commands.homes.gui.info", "<white>Home {slot} - {mode}", LanguageManager.ComponentPlaceholder.of("{slot}", slot), LanguageManager.ComponentPlaceholder.of("{mode}", mode)));
        info.setItemMeta(this.applyDisplayKey(infoMeta));
        inv.setItem(13, info);
        this.fillConfirmBackground(inv);
        player.openInventory(inv);
    }

    private ItemMeta applyDisplayKey(ItemMeta meta) {
        meta.getPersistentDataContainer().set(this.displayKey, PersistentDataType.BYTE, (Object)1);
        return meta;
    }

    private CompletableFuture<Void> setupHomeSlots(Player player, Inventory inv) {
        UUID uuid = player.getUniqueId();
        return this.homeManager.getAllHomes(uuid).thenAccept(homes -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            for (int i = 0; i < Math.min(8, this.config.maxHomes); ++i) {
                int slot = i + 1;
                Home home = (Home)homes.get(slot);
                inv.setItem(BED_SLOTS[i].intValue(), this.createBedItem(player, slot, home, home != null));
                inv.setItem(DYE_SLOTS[i].intValue(), this.createDyeItem(player, slot, home != null));
            }
        }));
    }

    private ItemStack createBedItem(Player player, int slot, Home home, boolean hasHome) {
        Material material = !this.canSetHome(player, slot) ? Material.RED_BED : (!hasHome ? Material.GRAY_BED : Material.BLUE_BED);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, "commands.homes.gui.home-title", "<white>Home {slot}", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (!this.canSetHome(player, slot)) {
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.no-permission", "<red>\u274c No Permission!", new LanguageManager.ComponentPlaceholder[0]));
        } else if (!hasHome) {
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.click-set", "<yellow>\u25b6 Click to set", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.name", "<gray>Name: <white>{home}", LanguageManager.ComponentPlaceholder.of("{home}", home.getName())));
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.coords", "<gray>XYZ: <white>{x}, {y}, {z}", LanguageManager.ComponentPlaceholder.of("{x}", Math.round(home.getX())), LanguageManager.ComponentPlaceholder.of("{y}", Math.round(home.getY())), LanguageManager.ComponentPlaceholder.of("{z}", Math.round(home.getZ()))));
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.world", "<gray>World: <white>{world}", LanguageManager.ComponentPlaceholder.of("{world}", this.simplifyWorldName(home.toLocation().getWorld().getName()))));
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.click-teleport", "<green>\u25b6 Left-click to teleport", new LanguageManager.ComponentPlaceholder[0]));
            lore.add(this.langManager.getMessageFor(player, "commands.homes.gui.click-manage", "<yellow>\u25b6 Right-click to manage", new LanguageManager.ComponentPlaceholder[0]));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createDyeItem(Player player, int slot, boolean hasHome) {
        if (!player.hasPermission("essc.command.removehome")) {
            return this.createFiller();
        }
        Material material = !hasHome ? Material.GRAY_DYE : Material.LIME_DYE;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, "homes.gui.manage-title", "<white>Manage Home {slot}", LanguageManager.ComponentPlaceholder.of("{slot}", slot)));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (!hasHome) {
            lore.add(this.langManager.getMessageFor(player, "homes.gui.empty", "<gray>Empty slot", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            lore.add(this.langManager.getMessageFor(player, "homes.gui.click-remove", "<red>\u25b6 Click to remove", new LanguageManager.ComponentPlaceholder[0]));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createFiller() {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        meta.displayName((Component)Component.empty());
        filler.setItemMeta(this.applyDisplayKey(meta));
        return filler;
    }

    private void fillBackground(Inventory inv) {
        ItemStack filler = this.createFiller();
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
    }

    private void fillConfirmBackground(Inventory inv) {
        ItemStack filler = this.createFiller();
        for (int i = 0; i < 27; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
    }

    private boolean isBorderSlot(int slot, int inventorySize) {
        return slot < 9 || slot >= inventorySize - 9 || slot % 9 == 0 || slot % 9 == 8;
    }

    private boolean isDisplayItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(this.displayKey, PersistentDataType.BYTE);
    }

    private boolean canSetHome(Player player, int slot) {
        if (!player.hasPermission("essc.command.sethome")) {
            return false;
        }
        if (player.hasPermission("essc.command.sethome.*")) {
            return true;
        }
        return player.hasPermission("essc.command.sethome." + slot);
    }

    private String simplifyWorldName(String worldName) {
        return worldName.replace("_", " ").replace("-", " ");
    }

    private record PendingAction(Action action, int slot) {
    }

    private static enum Action {
        SET,
        REMOVE,
        RENAME;

    }
}

